/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.HashMap;
import java.util.Map;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.AbstractInstructionAnalyzer;
import org.teavm.dependency.ClassSourcePacker;
import org.teavm.dependency.DependencyAnalyzer;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.FastInstructionAnalyzer;
import org.teavm.dependency.FastVirtualCallConsumer;
import org.teavm.dependency.MethodDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.ReferenceCache;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;

public class FastDependencyAnalyzer
extends DependencyAnalyzer {
    DependencyNode instancesNode;
    DependencyNode classesNode;
    private Map<MethodReference, FastVirtualCallConsumer> virtualCallConsumers = new HashMap<MethodReference, FastVirtualCallConsumer>();
    private Map<String, DependencyNode> subtypeNodes = new HashMap<String, DependencyNode>();

    public FastDependencyAnalyzer(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics, ReferenceCache referenceCache) {
        super(classSource, classLoader, services, diagnostics, referenceCache);
        this.instancesNode = new DependencyNode(this, null);
        this.classesNode = new DependencyNode(this, null);
        this.instancesNode.addConsumer(type -> this.getSubtypeNode(type.getName()).propagate(type));
    }

    @Override
    protected void processMethod(MethodDependency methodDep) {
        MethodReader method = methodDep.getMethod();
        ProgramReader program = method.getProgram();
        if (program != null) {
            FastInstructionAnalyzer instructionAnalyzer = new FastInstructionAnalyzer(this);
            instructionAnalyzer.setCaller(method.getReference());
            for (BasicBlockReader basicBlockReader : program.getBasicBlocks()) {
                basicBlockReader.readAllInstructions(instructionAnalyzer);
                for (TryCatchBlockReader tryCatchBlockReader : basicBlockReader.readTryCatchBlocks()) {
                    if (tryCatchBlockReader.getExceptionType() == null) continue;
                    this.linkClass(tryCatchBlockReader.getExceptionType());
                }
            }
            methodDep.variableNodes = new DependencyNode[program.variableCount()];
            for (int i = 0; i < methodDep.variableNodes.length; ++i) {
                methodDep.variableNodes[i] = this.instancesNode;
            }
        }
        if (method.hasModifier(ElementModifier.SYNCHRONIZED)) {
            this.processAsyncMethod();
        }
    }

    private void processAsyncMethod() {
        if (this.asyncSupported) {
            this.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_METHOD).use();
        }
        this.linkMethod(AbstractInstructionAnalyzer.MONITOR_ENTER_SYNC_METHOD).use();
        if (this.asyncSupported) {
            this.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_METHOD).use();
        }
        this.linkMethod(AbstractInstructionAnalyzer.MONITOR_EXIT_SYNC_METHOD).use();
    }

    @Override
    DependencyNode createParameterNode(MethodReference method, ValueType type, int index) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createResultNode(MethodReference method) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createThrownNode(MethodReference method) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createFieldNode(FieldReference field, ValueType type) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createArrayItemNode(DependencyNode parent) {
        return this.instancesNode;
    }

    @Override
    DependencyNode createClassValueNode(int degree, DependencyNode parent) {
        return this.classesNode;
    }

    private DependencyNode getSubtypeNode(String type) {
        if (type.equals("java.lang.Object")) {
            return this.instancesNode;
        }
        return this.subtypeNodes.computeIfAbsent(type, key -> {
            DependencyNode node = this.createNode();
            this.defer(() -> {
                block9: {
                    block7: {
                        block8: {
                            int degree;
                            for (degree = 0; degree < key.length() && key.charAt(degree) == '['; ++degree) {
                            }
                            if (degree <= 0) break block7;
                            ValueType fullType = ValueType.parse(key);
                            if (!(fullType instanceof ValueType.Object)) break block8;
                            String prefix = key.substring(0, degree) + "L";
                            String className = ((ValueType.Object)fullType).getClassName();
                            ClassReader cls = this.getClassSource().get(className);
                            if (cls == null) break block9;
                            if (cls.getParent() != null) {
                                node.connect(this.getSubtypeNode(prefix + cls.getParent().replace('.', '/') + ";"));
                            } else {
                                node.connect(this.getSubtypeNode("java.lang.Object"));
                            }
                            for (String itf : cls.getInterfaces()) {
                                node.connect(this.getSubtypeNode(prefix + itf.replace('.', '/') + ";"));
                            }
                            break block9;
                        }
                        node.connect(this.getSubtypeNode("java.lang.Object"));
                        break block9;
                    }
                    ClassReader cls = this.getClassSource().get((String)key);
                    if (cls != null) {
                        if (cls.getParent() != null) {
                            node.connect(this.getSubtypeNode(cls.getParent()));
                        }
                        for (String itf : cls.getInterfaces()) {
                            node.connect(this.getSubtypeNode(itf));
                        }
                    }
                }
            });
            return node;
        });
    }

    FastVirtualCallConsumer getVirtualCallConsumer(MethodReference method) {
        return this.virtualCallConsumers.computeIfAbsent(method, key -> {
            FastVirtualCallConsumer consumer = new FastVirtualCallConsumer(this.instancesNode, (MethodReference)key, this);
            this.defer(() -> this.getSubtypeNode(method.getClassName()).addConsumer(consumer));
            return consumer;
        });
    }

    @Override
    boolean domainOptimizationEnabled() {
        return false;
    }

    @Override
    public void cleanup(ClassSourcePacker classSourcePacker) {
        this.virtualCallConsumers.clear();
        this.subtypeNodes.clear();
        super.cleanup(classSourcePacker);
    }
}

