/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.util.Arrays;
import org.teavm.apachecommons.cli.CommandLine;
import org.teavm.apachecommons.cli.HelpFormatter;
import org.teavm.apachecommons.cli.OptionBuilder;
import org.teavm.apachecommons.cli.Options;
import org.teavm.apachecommons.cli.ParseException;
import org.teavm.apachecommons.cli.PosixParser;
import org.teavm.devserver.DevServer;
import org.teavm.tooling.ConsoleTeaVMToolLog;

public final class TeaVMDevServerRunner {
    private static Options options = new Options();
    private DevServer devServer;
    private CommandLine commandLine;

    private static void setupOptions() {
        OptionBuilder.withArgName("directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("a directory, relative to server's root, which serves generated files");
        OptionBuilder.withLongOpt("targetdir");
        options.addOption(OptionBuilder.create('d'));
        OptionBuilder.withArgName("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("a file where to put decompiled classes (classes.js by default)");
        OptionBuilder.withLongOpt("targetfile");
        options.addOption(OptionBuilder.create('f'));
        OptionBuilder.withArgName("classpath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("classpath element (either directory or jar file)");
        OptionBuilder.withLongOpt("classpath");
        options.addOption(OptionBuilder.create('p'));
        OptionBuilder.withArgName("sourcepath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("source path (either directory or jar file which contains source code)");
        OptionBuilder.withLongOpt("sourcepath");
        options.addOption(OptionBuilder.create('s'));
        OptionBuilder.withArgName("number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("port (default is 9090)");
        OptionBuilder.withLongOpt("port");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription("display indicator on web page");
        OptionBuilder.withLongOpt("indicator");
        options.addOption(OptionBuilder.create('i'));
        OptionBuilder.withDescription("deobfuscate stack traces");
        OptionBuilder.withLongOpt("deobfuscate-stack");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription("automatically reload page when compilation completes");
        OptionBuilder.withLongOpt("auto-reload");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withDescription("display more messages on server log");
        OptionBuilder.withLongOpt("verbose");
        options.addOption(OptionBuilder.create('v'));
        OptionBuilder.withArgName("URL");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("delegate requests to URL");
        OptionBuilder.withLongOpt("proxy-url");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withArgName("path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("delegate requests from path");
        OptionBuilder.withLongOpt("proxy-path");
        options.addOption(OptionBuilder.create());
    }

    private TeaVMDevServerRunner(CommandLine commandLine) {
        this.commandLine = commandLine;
        this.devServer = new DevServer();
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        if (args.length == 0) {
            TeaVMDevServerRunner.printUsage();
            return;
        }
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMDevServerRunner.printUsage();
            return;
        }
        TeaVMDevServerRunner runner = new TeaVMDevServerRunner(commandLine);
        runner.parseArguments();
        runner.runAll();
    }

    private void parseArguments() {
        String[] args;
        this.parseClassPathOptions();
        this.parseSourcePathOptions();
        this.parseOutputOptions();
        this.devServer.setIndicator(this.commandLine.hasOption("indicator"));
        this.devServer.setDeobfuscateStack(this.commandLine.hasOption("deobfuscate-stack"));
        this.devServer.setReloadedAutomatically(this.commandLine.hasOption("auto-reload"));
        this.devServer.setLog(new ConsoleTeaVMToolLog(this.commandLine.hasOption('v')));
        if (this.commandLine.hasOption("port")) {
            try {
                this.devServer.setPort(Integer.parseInt(this.commandLine.getOptionValue("port")));
            }
            catch (NumberFormatException e) {
                System.err.println("port must be numeric");
                TeaVMDevServerRunner.printUsage();
            }
        }
        if (this.commandLine.hasOption("proxy-url")) {
            this.devServer.setProxyUrl(this.commandLine.getOptionValue("proxy-url"));
        }
        if (this.commandLine.hasOption("proxy-path")) {
            this.devServer.setProxyPath(this.commandLine.getOptionValue("proxy-path"));
        }
        if ((args = this.commandLine.getArgs()).length != 1) {
            System.err.println("Unexpected arguments");
            TeaVMDevServerRunner.printUsage();
        } else if (args.length == 1) {
            this.devServer.setMainClass(args[0]);
        }
    }

    private void parseOutputOptions() {
        if (this.commandLine.hasOption("d")) {
            this.devServer.setPathToFile(this.commandLine.getOptionValue("d"));
        }
        if (this.commandLine.hasOption("f")) {
            this.devServer.setFileName(this.commandLine.getOptionValue("f"));
        }
    }

    private void parseClassPathOptions() {
        if (this.commandLine.hasOption('p')) {
            this.devServer.setClassPath(this.commandLine.getOptionValues('p'));
        }
    }

    private void parseSourcePathOptions() {
        if (this.commandLine.hasOption('s')) {
            this.devServer.getSourcePath().addAll(Arrays.asList(this.commandLine.getOptionValues('s')));
        }
    }

    private void runAll() {
        this.devServer.start();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMDevServerRunner.class.getName() + " [OPTIONS] [qualified.main.Class]", options);
        System.exit(-1);
    }

    static {
        TeaVMDevServerRunner.setupOptions();
    }
}

