/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TDoubleBuffer;
import org.teavm.classlib.java.nio.TDoubleBufferImpl;

class TDoubleBufferOverArray
extends TDoubleBufferImpl {
    boolean readOnly;
    int start;
    double[] array;

    public TDoubleBufferOverArray(int capacity) {
        this(0, capacity, new double[capacity], 0, capacity, false);
    }

    public TDoubleBufferOverArray(int start, int capacity, double[] array, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.readOnly = readOnly;
        this.array = array;
    }

    @Override
    TDoubleBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TDoubleBufferOverArray(this.start + start, capacity, this.array, position, limit, readOnly);
    }

    @Override
    double getElement(int index) {
        return this.array[index + this.start];
    }

    @Override
    void putElement(int index, double value) {
        this.array[index + this.start] = value;
    }

    @Override
    boolean isArrayPresent() {
        return true;
    }

    @Override
    double[] getArray() {
        return this.array;
    }

    @Override
    int getArrayOffset() {
        return this.start;
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.BIG_ENDIAN;
    }
}

