/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.jso.JSExceptions;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.DynamicGenerator;
import org.teavm.jso.impl.DynamicInjector;
import org.teavm.jso.impl.GeneratorAnnotationInstaller;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSAliasRenderer;
import org.teavm.jso.impl.JSBodyGenerator;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSDependencyListener;
import org.teavm.jso.impl.JSExceptionsDependencyListener;
import org.teavm.jso.impl.JSExceptionsGenerator;
import org.teavm.jso.impl.JSObjectClassTransformer;
import org.teavm.model.MethodReference;
import org.teavm.vm.TeaVMPluginUtil;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

public class JSOPlugin
implements TeaVMPlugin {
    @Override
    public void install(TeaVMHost host) {
        TeaVMJavaScriptHost jsHost = host.getExtension(TeaVMJavaScriptHost.class);
        if (jsHost == null) {
            return;
        }
        JSBodyRepository repository = new JSBodyRepository();
        host.registerService(JSBodyRepository.class, repository);
        host.add(new JSObjectClassTransformer(repository));
        JSDependencyListener dependencyListener = new JSDependencyListener(repository);
        JSAliasRenderer aliasRenderer = new JSAliasRenderer();
        host.add(dependencyListener);
        host.add(new JSExceptionsDependencyListener());
        jsHost.add(aliasRenderer);
        jsHost.addGeneratorProvider(new GeneratorAnnotationInstaller<Generator>(new JSBodyGenerator(), DynamicGenerator.class.getName()));
        jsHost.addInjectorProvider(new GeneratorAnnotationInstaller<Injector>(new JSBodyGenerator(), DynamicInjector.class.getName()));
        jsHost.addVirtualMethods(aliasRenderer);
        JSExceptionsGenerator exceptionsGenerator = new JSExceptionsGenerator();
        jsHost.add(new MethodReference(JSExceptions.class, "getJavaException", JSObject.class, Throwable.class), exceptionsGenerator);
        jsHost.add(new MethodReference(JSExceptions.class, "getJSException", Throwable.class, JSObject.class), exceptionsGenerator);
        TeaVMPluginUtil.handleNatives(host, JS.class);
    }
}

