/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TSimpleLongStreamIterator
implements PrimitiveIterator.OfLong {
    private static final byte NEEDS_MORE = 0;
    private static final byte HAS_DATA = 1;
    private static final byte LAST_ELEMENT = 2;
    private static final byte DONE = 3;
    private TSimpleLongStreamImpl stream;
    private long lastElement;
    private byte state;

    public TSimpleLongStreamIterator(TSimpleLongStreamImpl stream) {
        this.stream = stream;
    }

    @Override
    public boolean hasNext() {
        this.fetchIfNeeded();
        return this.state != 3;
    }

    @Override
    public long nextLong() {
        this.fetchIfNeeded();
        if (this.state == 3) {
            throw new NoSuchElementException();
        }
        long result = this.lastElement;
        this.state = (byte)(this.state == 2 ? 3 : 0);
        return result;
    }

    private void fetchIfNeeded() {
        if (this.state != 0) {
            return;
        }
        boolean hasMore = this.stream.next(e -> {
            this.lastElement = e;
            return false;
        });
        this.state = (byte)(hasMore ? 1 : 2);
        if (this.state == 2) {
            this.stream = null;
        }
    }
}

