/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TFlatMappingStreamImpl<T, S>
extends TSimpleStreamImpl<T> {
    private TSimpleStreamImpl<S> sourceStream;
    private TStream<? extends T> current;
    private Iterator<? extends T> iterator;
    private Function<? super S, ? extends TStream<? extends T>> mapper;
    private boolean done;

    public TFlatMappingStreamImpl(TSimpleStreamImpl<S> sourceStream, Function<? super S, ? extends TStream<? extends T>> mapper) {
        this.sourceStream = sourceStream;
        this.mapper = mapper;
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        while (true) {
            if (this.current == null) {
                if (this.done) {
                    return false;
                }
                boolean hasMore = this.sourceStream.next(e -> {
                    this.current = this.mapper.apply(e);
                    return false;
                });
                if (!hasMore) {
                    this.done = true;
                }
                if (this.current == null) {
                    this.done = true;
                    return false;
                }
            }
            if (this.current instanceof TSimpleStreamImpl) {
                TSimpleStreamImpl castCurrent = (TSimpleStreamImpl)this.current;
                if (castCurrent.next(consumer)) {
                    return true;
                }
                this.current = null;
                continue;
            }
            this.iterator = this.current.iterator();
            while (this.iterator.hasNext()) {
                T e2 = this.iterator.next();
                if (consumer.test(e2)) continue;
                return true;
            }
            this.iterator = null;
            this.current = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.current = null;
        this.iterator = null;
        this.sourceStream.close();
    }
}

