/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.stream.TBaseStream;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.longimpl.TArrayLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TEmptyLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TGenerateLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TGenericConcatLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TIterateLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TLongStreamBuilder;
import org.teavm.classlib.java.util.stream.longimpl.TRangeLongStream;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TSingleLongStreamImpl;
import org.teavm.classlib.java.util.stream.longimpl.TSpecializedConcatLongStream;

public interface TLongStream
extends TBaseStream<Long, TLongStream> {
    public TLongStream filter(LongPredicate var1);

    public TLongStream map(LongUnaryOperator var1);

    public <U> TStream<U> mapToObj(LongFunction<? extends U> var1);

    public TIntStream mapToInt(LongToIntFunction var1);

    public TDoubleStream mapToDouble(LongToDoubleFunction var1);

    public TLongStream flatMap(LongFunction<? extends TLongStream> var1);

    public TLongStream distinct();

    public TLongStream sorted();

    public TLongStream peek(LongConsumer var1);

    public TLongStream limit(long var1);

    public TLongStream skip(long var1);

    public void forEach(LongConsumer var1);

    public void forEachOrdered(LongConsumer var1);

    public long[] toArray();

    public long reduce(long var1, LongBinaryOperator var3);

    public OptionalLong reduce(LongBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjLongConsumer<R> var2, BiConsumer<R, R> var3);

    public long sum();

    public OptionalLong min();

    public OptionalLong max();

    public long count();

    public OptionalDouble average();

    public boolean anyMatch(LongPredicate var1);

    public boolean allMatch(LongPredicate var1);

    public boolean noneMatch(LongPredicate var1);

    public OptionalLong findFirst();

    public OptionalLong findAny();

    public TDoubleStream asDoubleStream();

    public TStream<Long> boxed();

    public PrimitiveIterator.OfLong iterator();

    public Spliterator.OfLong spliterator();

    public static Builder builder() {
        return new TLongStreamBuilder();
    }

    public static TLongStream empty() {
        return new TEmptyLongStreamImpl();
    }

    public static TLongStream of(long t) {
        return new TSingleLongStreamImpl(t);
    }

    public static TLongStream of(long ... values) {
        return new TArrayLongStreamImpl(values, 0, values.length);
    }

    public static TLongStream iterate(long seed, LongUnaryOperator f) {
        return new TIterateLongStream(seed, f);
    }

    public static TLongStream generate(LongSupplier s) {
        return new TGenerateLongStream(s);
    }

    public static TLongStream range(long startInclusive, long endExclusive) {
        return new TRangeLongStream(startInclusive, endExclusive);
    }

    public static TLongStream rangeClosed(long startInclusive, long endInclusive) {
        return new TRangeLongStream(startInclusive, endInclusive + 1L);
    }

    public static TLongStream concat(TLongStream a, TLongStream b) {
        if (a instanceof TSimpleLongStreamImpl && b instanceof TSimpleLongStreamImpl) {
            return new TSpecializedConcatLongStream((TSimpleLongStreamImpl)a, (TSimpleLongStreamImpl)b);
        }
        return new TGenericConcatLongStream(a, b);
    }

    public static interface Builder {
        public void accept(long var1);

        default public Builder add(long t) {
            this.accept(t);
            return this;
        }

        public TLongStream build();
    }
}

