/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.impl.unicode.DateFormatCollection;
import org.teavm.classlib.java.text.TFieldPosition;
import org.teavm.classlib.java.text.TFormat;
import org.teavm.classlib.java.text.TParseException;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.text.TSimpleDateFormat;
import org.teavm.classlib.java.util.TCalendar;
import org.teavm.classlib.java.util.TDate;
import org.teavm.classlib.java.util.THashMap;
import org.teavm.classlib.java.util.TLocale;
import org.teavm.classlib.java.util.TTimeZone;

public abstract class TDateFormat
extends TFormat {
    protected TCalendar calendar = TCalendar.getInstance();
    public static final int DEFAULT = 2;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;

    protected TDateFormat() {
    }

    @Override
    public Object clone() {
        TDateFormat clone = (TDateFormat)super.clone();
        clone.calendar = (TCalendar)this.calendar.clone();
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TDateFormat)) {
            return false;
        }
        TDateFormat dateFormat = (TDateFormat)object;
        return this.calendar.getFirstDayOfWeek() == dateFormat.calendar.getFirstDayOfWeek() && this.calendar.getMinimalDaysInFirstWeek() == dateFormat.calendar.getMinimalDaysInFirstWeek() && this.calendar.isLenient() == dateFormat.calendar.isLenient();
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer buffer, TFieldPosition field) {
        if (object instanceof TDate) {
            return this.format((TDate)object, buffer, field);
        }
        if (object instanceof Number) {
            return this.format(new TDate(((Number)object).longValue()), buffer, field);
        }
        throw new IllegalArgumentException();
    }

    public final String format(TDate date) {
        return this.format(date, new StringBuffer(), new TFieldPosition(0)).toString();
    }

    public abstract StringBuffer format(TDate var1, StringBuffer var2, TFieldPosition var3);

    public static TLocale[] getAvailableLocales() {
        return TLocale.getAvailableLocales();
    }

    public TCalendar getCalendar() {
        return this.calendar;
    }

    public TTimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public void setTimeZone(TTimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }

    public static TDateFormat getDateInstance() {
        return TDateFormat.getDateInstance(2);
    }

    public static TDateFormat getDateInstance(int style) {
        return TDateFormat.getDateInstance(style, TLocale.getDefault());
    }

    public static TDateFormat getDateInstance(int style, TLocale locale) {
        return new TSimpleDateFormat(TDateFormat.getDateFormatString(style, locale), locale);
    }

    private static String getDateFormatString(int style, TLocale locale) {
        DateFormatCollection formats = CLDRHelper.resolveDateFormats(locale.getLanguage(), locale.getCountry());
        switch (style) {
            case 3: {
                return formats.getShortFormat();
            }
            case 2: {
                return formats.getMediumFormat();
            }
            case 1: {
                return formats.getLongFormat();
            }
            case 0: {
                return formats.getFullFormat();
            }
        }
        throw new IllegalArgumentException("Unknown style: " + style);
    }

    public static TDateFormat getDateTimeInstance() {
        return TDateFormat.getDateTimeInstance(2, 2);
    }

    public static TDateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return TDateFormat.getDateTimeInstance(dateStyle, timeStyle, TLocale.getDefault());
    }

    public static TDateFormat getDateTimeInstance(int dateStyle, int timeStyle, TLocale locale) {
        String pattern = TDateFormat.getDateTimeFormatString(Math.max(dateStyle, timeStyle), locale);
        pattern = pattern.replace("{0}", TDateFormat.getTimeFormatString(dateStyle, locale)).replace("{1}", TDateFormat.getDateFormatString(timeStyle, locale));
        return new TSimpleDateFormat(pattern, locale);
    }

    public static String getDateTimeFormatString(int style, TLocale locale) {
        DateFormatCollection formats = CLDRHelper.resolveDateTimeFormats(locale.getLanguage(), locale.getCountry());
        switch (style) {
            case 3: {
                return formats.getShortFormat();
            }
            case 2: {
                return formats.getMediumFormat();
            }
            case 1: {
                return formats.getLongFormat();
            }
            case 0: {
                return formats.getFullFormat();
            }
        }
        throw new IllegalArgumentException("Unknown style: " + style);
    }

    public static final TDateFormat getInstance() {
        return TDateFormat.getDateTimeInstance(3, 3);
    }

    static String getStyleName(int style) {
        String styleName;
        switch (style) {
            case 3: {
                styleName = "SHORT";
                break;
            }
            case 2: {
                styleName = "MEDIUM";
                break;
            }
            case 1: {
                styleName = "LONG";
                break;
            }
            case 0: {
                styleName = "FULL";
                break;
            }
            default: {
                styleName = "";
            }
        }
        return styleName;
    }

    public static final TDateFormat getTimeInstance() {
        return TDateFormat.getTimeInstance(2);
    }

    public static TDateFormat getTimeInstance(int style) {
        return TDateFormat.getTimeInstance(style, TLocale.getDefault());
    }

    public static TDateFormat getTimeInstance(int style, TLocale locale) {
        return new TSimpleDateFormat(TDateFormat.getTimeFormatString(style, locale), locale);
    }

    private static String getTimeFormatString(int style, TLocale locale) {
        DateFormatCollection formats = CLDRHelper.resolveTimeFormats(locale.getLanguage(), locale.getCountry());
        switch (style) {
            case 3: {
                return formats.getShortFormat();
            }
            case 2: {
                return formats.getMediumFormat();
            }
            case 1: {
                return formats.getLongFormat();
            }
            case 0: {
                return formats.getFullFormat();
            }
        }
        throw new IllegalArgumentException("Unknown style: " + style);
    }

    public int hashCode() {
        return this.calendar.getFirstDayOfWeek() + this.calendar.getMinimalDaysInFirstWeek() + (this.calendar.isLenient() ? 1231 : 1237);
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public TDate parse(String string) throws TParseException {
        TParsePosition position = new TParsePosition(0);
        TDate date = this.parse(string, position);
        if (position.getErrorIndex() > 0) {
            throw new TParseException("Unparseable date: " + string, position.getErrorIndex());
        }
        return date;
    }

    public abstract TDate parse(String var1, TParsePosition var2);

    @Override
    public Object parseObject(String string, TParsePosition position) {
        return this.parse(string, position);
    }

    public void setCalendar(TCalendar cal) {
        this.calendar = cal;
    }

    public void setLenient(boolean value) {
        this.calendar.setLenient(value);
    }

    public static class Field
    extends TFormat.Field {
        private static THashMap<Integer, Field> table = new THashMap();
        public static final Field ERA = new Field("era", 0);
        public static final Field YEAR = new Field("year", 1);
        public static final Field MONTH = new Field("month", 2);
        public static final Field HOUR_OF_DAY0 = new Field("hour of day", 11);
        public static final Field HOUR_OF_DAY1 = new Field("hour of day 1", -1);
        public static final Field MINUTE = new Field("minute", 12);
        public static final Field SECOND = new Field("second", 13);
        public static final Field MILLISECOND = new Field("millisecond", 14);
        public static final Field DAY_OF_WEEK = new Field("day of week", 7);
        public static final Field DAY_OF_MONTH = new Field("day of month", 5);
        public static final Field DAY_OF_YEAR = new Field("day of year", 6);
        public static final Field DAY_OF_WEEK_IN_MONTH = new Field("day of week in month", 8);
        public static final Field WEEK_OF_YEAR = new Field("week of year", 3);
        public static final Field WEEK_OF_MONTH = new Field("week of month", 4);
        public static final Field AM_PM = new Field("am pm", 9);
        public static final Field HOUR0 = new Field("hour", 10);
        public static final Field HOUR1 = new Field("hour 1", -1);
        public static final Field TIME_ZONE = new Field("time zone", -1);
        private int calendarField = -1;

        protected Field(String fieldName, int calendarField) {
            super(fieldName);
            this.calendarField = calendarField;
            if (calendarField != -1 && table.get(new Integer(calendarField)) == null) {
                table.put(new Integer(calendarField), this);
            }
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        public static Field ofCalendarField(int calendarField) {
            if (calendarField < 0 || calendarField >= 17) {
                throw new IllegalArgumentException();
            }
            return table.get(new Integer(calendarField));
        }
    }
}

