/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.tz;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.teavm.classlib.impl.tz.StorableDateTimeZone;
import org.teavm.classlib.impl.tz.TimeZoneCache;
import org.teavm.classlib.impl.tz.TimeZoneResource;
import org.teavm.classlib.impl.tz.ZoneInfoCompiler;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.ResourceMap;

public class TimeZoneGenerator
implements MetadataGenerator {
    public static final String TIMEZONE_DB_VERSION = "2019b";
    public static final String TIMEZONE_DB_PATH = "org/teavm/classlib/impl/tz/tzdata2019b.zip";

    public static void compile(ZoneInfoCompiler compiler, ClassLoader classLoader) {
        try (InputStream input = classLoader.getResourceAsStream(TIMEZONE_DB_PATH);
             ZipInputStream zip = new ZipInputStream(new BufferedInputStream(input));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                switch (entry.getName().substring("tzdata2019b/".length())) {
                    case "africa": 
                    case "antarctica": 
                    case "asia": 
                    case "australasia": 
                    case "etcetera": 
                    case "europe": 
                    case "northamerica": 
                    case "pacificnew": 
                    case "southamerica": {
                        compiler.parseDataFile(new BufferedReader(new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)), false);
                        break;
                    }
                    case "backward": 
                    case "backzone": {
                        compiler.parseDataFile(new BufferedReader(new InputStreamReader((InputStream)zip, StandardCharsets.UTF_8)), true);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating time zones", e);
        }
    }

    @Override
    public ResourceMap<ResourceMap<TimeZoneResource>> generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        Collection<StorableDateTimeZone> zones;
        ResourceMap<ResourceMap<TimeZoneResource>> result = context.createResourceMap();
        ZoneInfoCompiler compiler = new ZoneInfoCompiler();
        try (InputStream input = context.getClassLoader().getResourceAsStream("org/teavm/classlib/impl/tz/cache");){
            if (input != null) {
                TimeZoneCache cache = new TimeZoneCache();
                zones = cache.read(new BufferedInputStream(input)).values();
            } else {
                TimeZoneGenerator.compile(compiler, context.getClassLoader());
                zones = compiler.compile().values();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating time zones", e);
        }
        for (StorableDateTimeZone tz : zones) {
            String locationName;
            String areaName;
            String id = tz.getID();
            int sepIndex = id.indexOf(47);
            if (sepIndex < 0) {
                areaName = "";
                locationName = id;
            } else {
                areaName = id.substring(0, sepIndex);
                locationName = id.substring(sepIndex + 1);
            }
            ResourceMap<TimeZoneResource> area = result.get(areaName);
            if (area == null) {
                area = context.createResourceMap();
                result.put(areaName, area);
            }
            TimeZoneResource tzRes = context.createResource(TimeZoneResource.class);
            StringBuilder data = new StringBuilder();
            tz.write(data);
            tzRes.setData(data.toString());
            area.put(locationName, tzRes);
        }
        return result;
    }
}

