/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmExpression;

public class WasmFunction {
    WasmModule module;
    private String name;
    private String exportName;
    private String importName;
    private String importModule;
    private List<WasmType> parameters = new ArrayList<WasmType>();
    private WasmType result;
    private List<WasmLocal> localVariables = new ArrayList<WasmLocal>();
    private List<WasmLocal> readonlyLocalVariables = Collections.unmodifiableList(this.localVariables);
    private List<WasmExpression> body = new ArrayList<WasmExpression>();

    public WasmFunction(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public WasmModule getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public String getImportName() {
        return this.importName;
    }

    public void setImportName(String importName) {
        this.importName = importName;
    }

    public String getImportModule() {
        return this.importModule;
    }

    public void setImportModule(String importModule) {
        this.importModule = importModule;
    }

    public WasmType getResult() {
        return this.result;
    }

    public void setResult(WasmType result) {
        this.result = result;
    }

    public List<WasmType> getParameters() {
        return this.parameters;
    }

    public List<WasmLocal> getLocalVariables() {
        return this.readonlyLocalVariables;
    }

    public List<WasmExpression> getBody() {
        return this.body;
    }

    public void add(WasmLocal local) {
        if (local.function != null) {
            throw new IllegalArgumentException("This local is already registered in another function");
        }
        local.function = this;
        local.index = this.localVariables.size();
        this.localVariables.add(local);
    }
}

