/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.generate;

import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.c.generate.ClassGenerator;
import org.teavm.model.ValueType;

public abstract class IncludeManager {
    private String currentFileName;
    private Set<String> includedFiles = new HashSet<String>();
    private Set<String> includedClasses = new HashSet<String>();
    private Set<ValueType> includedTypes = new HashSet<ValueType>();

    public void init(String currentFileName) {
        this.currentFileName = currentFileName;
        this.includedFiles.clear();
        this.includedClasses.clear();
        this.includedTypes.clear();
    }

    public abstract void addInclude(String var1);

    public String relativeIncludeString(String fileName) {
        int next;
        int next2;
        int commonIndex = 0;
        while ((next2 = fileName.indexOf(47, commonIndex)) >= 0 && next2 <= this.currentFileName.length() && this.currentFileName.regionMatches(commonIndex, fileName, commonIndex, next2 - commonIndex + 1)) {
            commonIndex = next2 + 1;
        }
        StringBuilder sb = new StringBuilder("\"");
        int index = commonIndex;
        while ((next = this.currentFileName.indexOf(47, index)) >= 0) {
            index = next + 1;
            sb.append("../");
        }
        return sb.append(fileName.substring(commonIndex)).append("\"").toString();
    }

    public void includeClass(String className) {
        if (!this.includedClasses.add(className)) {
            return;
        }
        this.includePath(ClassGenerator.fileName(className) + ".h");
    }

    public void includeType(ValueType type) {
        if (!this.includedTypes.add(type)) {
            return;
        }
        this.includePath(ClassGenerator.fileName(type) + ".h");
    }

    public void includePath(String fileName) {
        if (!this.includedFiles.add(fileName)) {
            return;
        }
        this.addInclude(this.relativeIncludeString(fileName));
    }
}

