/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.JsrSessionFactory;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointScanner;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.AnnotatedServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.BasicServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.JsrCreator;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerExtendsEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.SimpleServerEndpointMetadata;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

@ManagedObject(value="JSR356 Server Container")
public class ServerContainer
extends ClientContainer
implements javax.websocket.server.ServerContainer {
    private static final Logger LOG = Log.getLogger(ServerContainer.class);
    private final NativeWebSocketConfiguration configuration;
    private List<Class<?>> deferredEndpointClasses;
    private List<ServerEndpointConfig> deferredEndpointConfigs;

    public static WebSocketContainer getWebSocketContainer() {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context == null) {
            return null;
        }
        ContextHandler handler = ContextHandler.getContextHandler(context);
        if (handler == null) {
            return null;
        }
        if (!(handler instanceof ServletContextHandler)) {
            return null;
        }
        return (WebSocketContainer)handler.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
    }

    @Deprecated
    public ServerContainer(NativeWebSocketConfiguration configuration, Executor executor) {
        this(configuration, (HttpClient)null);
    }

    public ServerContainer(NativeWebSocketConfiguration configuration, HttpClient httpClient) {
        super(configuration.getFactory(), httpClient);
        this.configuration = configuration;
        EventDriverFactory eventDriverFactory = this.configuration.getFactory().getEventDriverFactory();
        eventDriverFactory.addImplementation(new JsrServerEndpointImpl());
        eventDriverFactory.addImplementation(new JsrServerExtendsEndpointImpl());
        this.configuration.getFactory().addSessionFactory(new JsrSessionFactory(this));
        this.addBean(this.configuration);
    }

    public EndpointInstance newClientEndpointInstance(Object endpoint, ServerEndpointConfig config, String path) {
        EndpointMetadata metadata = this.getClientEndpointMetadata(endpoint.getClass(), config);
        ServerEndpointConfig cec = config;
        if (config == null) {
            cec = metadata instanceof AnnotatedServerEndpointMetadata ? ((AnnotatedServerEndpointMetadata)metadata).getConfig() : new BasicServerEndpointConfig(this, endpoint.getClass(), path);
        }
        return new EndpointInstance(endpoint, cec, metadata);
    }

    @Override
    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (this.isStarted() || this.isStarting()) {
            ServerEndpointMetadata metadata = this.getServerEndpointMetadata(endpointClass, null);
            this.addEndpoint(metadata);
        } else {
            if (this.deferredEndpointClasses == null) {
                this.deferredEndpointClasses = new ArrayList();
            }
            this.deferredEndpointClasses.add(endpointClass);
        }
    }

    private void addEndpoint(ServerEndpointMetadata metadata) throws DeploymentException {
        JsrCreator creator = new JsrCreator(this, metadata, this.configuration.getFactory().getExtensionFactory());
        this.configuration.addMapping("uri-template|" + metadata.getPath(), (WebSocketCreator)creator);
    }

    @Override
    public void addEndpoint(ServerEndpointConfig config) throws DeploymentException {
        if (this.isStarted() || this.isStarting()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({}) path={} endpoint={}", config, config.getPath(), config.getEndpointClass());
            }
            ServerEndpointMetadata metadata = this.getServerEndpointMetadata(config.getEndpointClass(), config);
            this.addEndpoint(metadata);
        } else {
            if (this.deferredEndpointConfigs == null) {
                this.deferredEndpointConfigs = new ArrayList<ServerEndpointConfig>();
            }
            this.deferredEndpointConfigs.add(config);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.deferredEndpointClasses != null) {
            for (Class clazz : this.deferredEndpointClasses) {
                this.addEndpoint(clazz);
            }
            this.deferredEndpointClasses.clear();
        }
        if (this.deferredEndpointConfigs != null) {
            for (ServerEndpointConfig serverEndpointConfig : this.deferredEndpointConfigs) {
                this.addEndpoint(serverEndpointConfig);
            }
            this.deferredEndpointConfigs.clear();
        }
    }

    public ServerEndpointMetadata getServerEndpointMetadata(Class<?> endpoint, ServerEndpointConfig config) throws DeploymentException {
        ServerEndpointMetadata metadata = null;
        ServerEndpoint anno = endpoint.getAnnotation(ServerEndpoint.class);
        if (anno != null) {
            AnnotatedServerEndpointMetadata ametadata = new AnnotatedServerEndpointMetadata(this, endpoint, config);
            AnnotatedEndpointScanner<ServerEndpoint, ServerEndpointConfig> scanner = new AnnotatedEndpointScanner<ServerEndpoint, ServerEndpointConfig>(ametadata);
            metadata = ametadata;
            scanner.scan();
        } else if (Endpoint.class.isAssignableFrom(endpoint)) {
            Class<?> eendpoint = endpoint;
            metadata = new SimpleServerEndpointMetadata(eendpoint, config);
        } else {
            StringBuilder err = new StringBuilder();
            err.append("Not a recognized websocket [");
            err.append(endpoint.getName());
            err.append("] does not extend @").append(ServerEndpoint.class.getName());
            err.append(" or extend from ").append(Endpoint.class.getName());
            throw new DeploymentException("Unable to identify as valid Endpoint: " + endpoint);
        }
        return metadata;
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.configuration.getPolicy().getAsyncWriteTimeout();
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.configuration.getPolicy().getMaxBinaryMessageSize();
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.configuration.getPolicy().getIdleTimeout();
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.configuration.getPolicy().getMaxTextMessageSize();
    }

    public WebSocketServerFactory getWebSocketServerFactory() {
        return this.configuration.getFactory();
    }

    @Override
    public void setAsyncSendTimeout(long ms) {
        super.setAsyncSendTimeout(ms);
        this.configuration.getPolicy().setAsyncWriteTimeout(ms);
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        super.setDefaultMaxBinaryMessageBufferSize(max);
        this.configuration.getPolicy().setMaxBinaryMessageSize(max);
        this.configuration.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long ms) {
        super.setDefaultMaxSessionIdleTimeout(ms);
        this.configuration.getPolicy().setIdleTimeout(ms);
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        super.setDefaultMaxTextMessageBufferSize(max);
        this.configuration.getPolicy().setMaxTextMessageSize(max);
        this.configuration.getPolicy().setMaxTextMessageBufferSize(max);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.getWebSocketServerFactory().onSessionClosed(session);
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        this.getWebSocketServerFactory().onSessionOpened(session);
    }

    @Override
    public Set<Session> getOpenSessions() {
        return new HashSet<Session>(this.getWebSocketServerFactory().getBeans(Session.class));
    }
}

