/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.MessageHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.util.ReflectUtils;
import org.eclipse.jetty.websocket.jsr356.metadata.MessageHandlerMetadata;

public class MessageHandlerFactory {
    private static final Logger LOG = Log.getLogger(MessageHandlerFactory.class);
    private Map<Class<? extends MessageHandler>, List<MessageHandlerMetadata>> registered = new ConcurrentHashMap<Class<? extends MessageHandler>, List<MessageHandlerMetadata>>();

    public List<MessageHandlerMetadata> getMetadata(Class<? extends MessageHandler> handler) throws IllegalStateException {
        List<MessageHandlerMetadata> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMetadata({})", handler);
        }
        if ((ret = this.registered.get(handler)) != null) {
            return ret;
        }
        return this.register(handler);
    }

    public List<MessageHandlerMetadata> register(Class<? extends MessageHandler> handler) {
        Class<?> onMessageClass;
        ArrayList<MessageHandlerMetadata> metadatas = new ArrayList<MessageHandlerMetadata>();
        boolean partial = false;
        if (MessageHandler.Partial.class.isAssignableFrom(handler)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("supports Partial: {}", handler);
            }
            partial = true;
            onMessageClass = ReflectUtils.findGenericClassFor(handler, MessageHandler.Partial.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Partial message class: {}", onMessageClass);
            }
            metadatas.add(new MessageHandlerMetadata(handler, onMessageClass, partial));
        }
        if (MessageHandler.Whole.class.isAssignableFrom(handler)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("supports Whole: {}", handler.getName());
            }
            partial = false;
            onMessageClass = ReflectUtils.findGenericClassFor(handler, MessageHandler.Whole.class);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Whole message class: {}", onMessageClass);
            }
            metadatas.add(new MessageHandlerMetadata(handler, onMessageClass, partial));
        }
        this.registered.put(handler, metadatas);
        return metadatas;
    }
}

