/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cli;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.teavm.cli.ConsoleTeaVMToolLog;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.testing.TestAdapter;
import org.teavm.tooling.TeaVMTestTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;

public final class TeaVMTestRunner {
    private TeaVMTestRunner() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"a directory where to put generated files (current directory by default)");
        OptionBuilder.withLongOpt((String)"targetdir");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withDescription((String)"causes TeaVM to generate minimized JavaScript file");
        OptionBuilder.withLongOpt((String)"minify");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"how many threads should TeaVM run");
        OptionBuilder.withLongOpt((String)"threads");
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"qualified class name of test adapter");
        OptionBuilder.withLongOpt((String)"adapter");
        options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.hasArg();
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"class name");
        OptionBuilder.withDescription((String)"qualified class names of transformers");
        OptionBuilder.withLongOpt((String)"transformers");
        options.addOption(OptionBuilder.create((String)"T"));
        if (args.length == 0) {
            TeaVMTestRunner.printUsage(options);
            return;
        }
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            TeaVMTestRunner.printUsage(options);
            return;
        }
        TeaVMTestTool tool = new TeaVMTestTool();
        tool.setOutputDir(new File(commandLine.getOptionValue("d", ".")));
        tool.setMinifying(commandLine.hasOption("m"));
        try {
            tool.setNumThreads(Integer.parseInt(commandLine.getOptionValue("t", "1")));
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid number specified for -t option");
            TeaVMTestRunner.printUsage(options);
            return;
        }
        if (commandLine.hasOption("a")) {
            tool.setAdapter(TeaVMTestRunner.instantiateAdapter(commandLine.getOptionValue("a")));
        }
        if (commandLine.hasOption("T")) {
            for (String transformerType : commandLine.getOptionValues("T")) {
                tool.getTransformers().add(TeaVMTestRunner.instantiateTransformer(transformerType));
            }
        }
        if ((args = commandLine.getArgs()).length == 0) {
            System.err.println("You did not specify any test classes");
            TeaVMTestRunner.printUsage(options);
            return;
        }
        tool.getTestClasses().addAll(Arrays.asList(args));
        tool.setLog((TeaVMToolLog)new ConsoleTeaVMToolLog());
        tool.getProperties().putAll((Map<?, ?>)System.getProperties());
        long start = System.currentTimeMillis();
        try {
            tool.generate();
        }
        catch (TeaVMToolException e) {
            e.printStackTrace(System.err);
            System.exit(-2);
        }
        System.out.println("Operation took " + (System.currentTimeMillis() - start) + " milliseconds");
    }

    private static TestAdapter instantiateAdapter(String adapterName) {
        Constructor<?> cons;
        Class<?> adapterClass;
        try {
            adapterClass = Class.forName(adapterName, true, TeaVMTestRunner.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            System.err.println("Adapter not found: " + adapterName);
            System.exit(-1);
            return null;
        }
        if (!TestAdapter.class.isAssignableFrom(adapterClass)) {
            System.err.println("Adapter class does not implement TestAdapter: " + adapterName);
            System.exit(-1);
            return null;
        }
        try {
            cons = adapterClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Adapter class does not contain no-arg constructor: " + adapterName);
            System.exit(-1);
            return null;
        }
        try {
            return (TestAdapter)cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.err.println("Error instantiating adapter: " + adapterName);
            e.printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
        catch (InvocationTargetException e) {
            System.err.println("Error instantiating adapter: " + adapterName);
            e.getTargetException().printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
    }

    private static ClassHolderTransformer instantiateTransformer(String transformerName) {
        Constructor<?> cons;
        Class<?> adapterClass;
        try {
            adapterClass = Class.forName(transformerName, true, TeaVMTestRunner.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            System.err.println("Transformer not found: " + transformerName);
            System.exit(-1);
            return null;
        }
        if (!ClassHolderTransformer.class.isAssignableFrom(adapterClass)) {
            System.err.println("Transformer class does not implement ClassHolderTransformer: " + transformerName);
            System.exit(-1);
            return null;
        }
        try {
            cons = adapterClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Transformer class does not contain no-arg constructor: " + transformerName);
            System.exit(-1);
            return null;
        }
        try {
            return (ClassHolderTransformer)cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.err.println("Error instantiating transformer: " + transformerName);
            e.printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
        catch (InvocationTargetException e) {
            System.err.println("Error instantiating transformer: " + transformerName);
            e.getTargetException().printStackTrace(System.err);
            System.exit(-1);
            return null;
        }
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java " + TeaVMTestRunner.class.getName() + " [OPTIONS] test_name {test_name}", options);
        System.exit(-1);
    }
}

