/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio.file;

import java.io.IOException;

public class TFileSystemException
extends IOException {
    private static final long serialVersionUID = 9093298181737952280L;
    private final String file;
    private final String other;
    private final String reason;

    public TFileSystemException(String file) {
        this.file = file;
        this.other = null;
        this.reason = null;
    }

    public TFileSystemException(String file, String other, String reason) {
        super(reason);
        this.file = file;
        this.other = other;
        this.reason = reason;
    }

    public String getFile() {
        return this.file;
    }

    public String getOtherFile() {
        return this.other;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public String getMessage() {
        if (this.file == null && this.other == null) {
            return this.reason;
        }
        StringBuilder out = new StringBuilder();
        if (this.file != null) {
            out.append(this.file);
        }
        if (this.other != null) {
            out.append(" -> ").append(this.other);
        }
        if (this.reason != null) {
            out.append(": ").append(this.reason);
        }
        return out.toString();
    }
}

