/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.text;

import java.math.BigInteger;

public final class FloatSynthesizerGenerator {
    private FloatSynthesizerGenerator() {
    }

    public static void main(String[] args) {
        int[] mantissaList = new int[100];
        int[] expList = new int[100];
        int binOneShift = 256;
        BigInteger binOne = BigInteger.ONE.shiftLeft(binOneShift);
        BigInteger dec = BigInteger.valueOf(100000000L);
        for (int i = 0; i <= 50; ++i) {
            BigInteger quot = binOne.divide(dec);
            mantissaList[50 - i] = FloatSynthesizerGenerator.extractInt(quot);
            int exp = quot.bitLength() - binOneShift + 30;
            expList[50 - i] = 127 + exp;
            dec = dec.multiply(BigInteger.valueOf(10L));
        }
        dec = BigInteger.valueOf(100000000L);
        BigInteger q = BigInteger.TEN;
        for (int i = 1; i < 50; ++i) {
            BigInteger quot = q.shiftLeft(binOneShift).divide(dec);
            mantissaList[50 + i] = FloatSynthesizerGenerator.extractInt(quot);
            int exp = quot.bitLength() - binOneShift + 30;
            expList[50 + i] = 127 + exp;
            q = q.multiply(BigInteger.TEN);
        }
        System.out.println("[mantissa]");
        for (int value : mantissaList) {
            System.out.println(value + ",");
        }
        System.out.println();
        System.out.println("[exponent]");
        for (int value : expList) {
            System.out.println(value + ",");
        }
    }

    private static int extractInt(BigInteger n) {
        return n.shiftRight(n.bitLength() - 33).add(BigInteger.ONE).shiftRight(1).intValue();
    }
}

