/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.doubleimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.TDoubleSummaryStatistics;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.TStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TAllMatchConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TAnyMatchConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TAverageDoubleConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TBoxedDoubleStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TCloseHandlingDoubleStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TCountingDoubleConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TDistinctDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TDropWhileDoubleStream;
import org.teavm.classlib.java.util.stream.doubleimpl.TFilteringDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TFindFirstDoubleConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TFlatMappingDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TLimitingDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TMappingDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TMappingToIntStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TMappingToLongStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TMappingToObjStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TPeekingDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TReducingDoubleConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamIterator;
import org.teavm.classlib.java.util.stream.doubleimpl.TSimpleDoubleStreamSpliterator;
import org.teavm.classlib.java.util.stream.doubleimpl.TSkippingDoubleStreamImpl;
import org.teavm.classlib.java.util.stream.doubleimpl.TSumDoubleConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TSummaryDoubleConsumer;
import org.teavm.classlib.java.util.stream.doubleimpl.TTakeWhileDoubleStream;

public abstract class TSimpleDoubleStreamImpl
implements TDoubleStream {
    @Override
    public TDoubleStream filter(DoublePredicate predicate) {
        return new TFilteringDoubleStreamImpl(this, predicate);
    }

    @Override
    public TDoubleStream map(DoubleUnaryOperator mapper) {
        return new TMappingDoubleStreamImpl(this, mapper);
    }

    @Override
    public <U> TStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return new TMappingToObjStreamImpl<U>(this, mapper);
    }

    @Override
    public TIntStream mapToInt(DoubleToIntFunction mapper) {
        return new TMappingToIntStreamImpl(this, mapper);
    }

    @Override
    public TLongStream mapToLong(DoubleToLongFunction mapper) {
        return new TMappingToLongStreamImpl(this, mapper);
    }

    @Override
    public TDoubleStream flatMap(DoubleFunction<? extends TDoubleStream> mapper) {
        return new TFlatMappingDoubleStreamImpl(this, mapper);
    }

    @Override
    public TDoubleStream distinct() {
        return new TDistinctDoubleStreamImpl(this);
    }

    @Override
    public TDoubleStream sorted() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return TDoubleStream.of(array);
    }

    @Override
    public TDoubleStream peek(DoubleConsumer action) {
        return new TPeekingDoubleStreamImpl(this, action);
    }

    @Override
    public TDoubleStream limit(long maxSize) {
        return new TLimitingDoubleStreamImpl(this, (int)maxSize);
    }

    @Override
    public TDoubleStream takeWhile(DoublePredicate predicate) {
        return new TTakeWhileDoubleStream(this, predicate);
    }

    @Override
    public TDoubleStream dropWhile(DoublePredicate predicate) {
        return new TDropWhileDoubleStream(this, predicate);
    }

    @Override
    public TDoubleStream skip(long n) {
        return new TSkippingDoubleStreamImpl(this, (int)n);
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        boolean hasMore;
        while (hasMore = this.next(e -> {
            action.accept(e);
            return true;
        })) {
        }
    }

    @Override
    public double[] toArray() {
        int estimatedSize = this.estimateSize();
        if (estimatedSize < 0) {
            ArrayList list = new ArrayList();
            while (this.next(list::add)) {
            }
            double[] array = new double[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Double)list.get(i);
            }
            return array;
        }
        double[] array = new double[estimatedSize];
        ArrayFillingConsumer consumer = new ArrayFillingConsumer(array);
        while (this.next(consumer)) {
        }
        if (consumer.index < array.length) {
            array = Arrays.copyOf(array, consumer.index);
        }
        return array;
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator accumulator) {
        TReducingDoubleConsumer consumer = new TReducingDoubleConsumer(accumulator, identity, true);
        while (this.next(consumer)) {
        }
        return consumer.result;
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator accumulator) {
        TReducingDoubleConsumer consumer = new TReducingDoubleConsumer(accumulator, 0.0, false);
        while (this.next(consumer)) {
        }
        return consumer.initialized ? OptionalDouble.of(consumer.result) : OptionalDouble.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        boolean hasMore;
        Object collection = supplier.get();
        while (hasMore = this.next(e -> {
            accumulator.accept(collection, e);
            return true;
        })) {
        }
        return collection;
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(Math::min);
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(Math::max);
    }

    @Override
    public long count() {
        TCountingDoubleConsumer consumer = new TCountingDoubleConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count;
    }

    @Override
    public double sum() {
        TSumDoubleConsumer consumer = new TSumDoubleConsumer();
        while (this.next(consumer)) {
        }
        return consumer.sum;
    }

    @Override
    public OptionalDouble average() {
        TAverageDoubleConsumer consumer = new TAverageDoubleConsumer();
        while (this.next(consumer)) {
        }
        return consumer.count > 0 ? OptionalDouble.of(consumer.sum / (double)consumer.count) : OptionalDouble.empty();
    }

    @Override
    public TDoubleSummaryStatistics summaryStatistics() {
        TSummaryDoubleConsumer consumer = new TSummaryDoubleConsumer();
        while (this.next(consumer)) {
        }
        return consumer.stat;
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        TAnyMatchConsumer consumer = new TAnyMatchConsumer(predicate);
        while (!consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        TAllMatchConsumer consumer = new TAllMatchConsumer(predicate);
        while (consumer.matched && this.next(consumer)) {
        }
        return consumer.matched;
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        TFindFirstDoubleConsumer consumer = new TFindFirstDoubleConsumer();
        while (!consumer.hasAny && this.next(consumer)) {
        }
        return consumer.hasAny ? OptionalDouble.of(consumer.result) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble findAny() {
        return this.findFirst();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return new TSimpleDoubleStreamIterator(this);
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return new TSimpleDoubleStreamSpliterator(this);
    }

    @Override
    public TStream<Double> boxed() {
        return new TBoxedDoubleStream(this);
    }

    @Override
    public boolean isParallel() {
        return false;
    }

    @Override
    public TDoubleStream sequential() {
        return this;
    }

    @Override
    public TDoubleStream parallel() {
        return this;
    }

    @Override
    public TDoubleStream unordered() {
        return this;
    }

    @Override
    public TDoubleStream onClose(Runnable closeHandler) {
        return new TCloseHandlingDoubleStream(this, closeHandler);
    }

    @Override
    public void close() throws Exception {
    }

    protected int estimateSize() {
        return -1;
    }

    public abstract boolean next(DoublePredicate var1);

    static class ArrayFillingConsumer
    implements DoublePredicate {
        double[] array;
        int index;

        ArrayFillingConsumer(double[] array) {
            this.array = array;
        }

        @Override
        public boolean test(double t) {
            this.array[this.index++] = t;
            return true;
        }
    }
}

