/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TLinkedHashMap;
import org.teavm.classlib.java.util.TLinkedHashMapEntrySet;
import org.teavm.classlib.java.util.TLinkedHashMapKeySet;
import org.teavm.classlib.java.util.TLinkedHashMapValues;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TSequencedCollection;
import org.teavm.classlib.java.util.TSequencedMap;
import org.teavm.classlib.java.util.TSequencedSet;
import org.teavm.classlib.java.util.TSet;

class TReversedLinkedHashMap<K, V>
extends TAbstractMap<K, V>
implements TSequencedMap<K, V> {
    private final TLinkedHashMap<K, V> base;

    TReversedLinkedHashMap(TLinkedHashMap<K, V> base) {
        this.base = base;
    }

    @Override
    public boolean equals(Object o) {
        return this.base.equals(o);
    }

    @Override
    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.base.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.base.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.base.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.base.remove(key);
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> m) {
        this.base.putAll(m);
    }

    @Override
    public void clear() {
        this.base.clear();
    }

    @Override
    public TSet<K> keySet() {
        return this.base.sequencedKeySet().reversed();
    }

    @Override
    public TCollection<V> values() {
        return this.base.sequencedValues().reversed();
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return this.base.sequencedEntrySet().reversed();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.base.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (this.base.elementCount > 0) {
            int prevModCount = this.base.modCount;
            TLinkedHashMap.LinkedHashMapEntry entry = this.base.tail;
            do {
                action.accept(entry.key, entry.value);
                entry = entry.chainBackward;
                if (this.base.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        if (this.base.elementCount > 0) {
            int prevModCount = this.base.modCount;
            TLinkedHashMap.LinkedHashMapEntry entry = this.base.tail;
            do {
                entry.value = function.apply(entry.key, entry.value);
                entry = entry.chainBackward;
                if (this.base.modCount == prevModCount) continue;
                throw new TConcurrentModificationException();
            } while (entry != null);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.base.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.base.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.base.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.base.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.base.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.base.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.base.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.base.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public TSequencedMap<K, V> reversed() {
        return this.base;
    }

    @Override
    public TMap.Entry<K, V> firstEntry() {
        return this.base.lastEntry();
    }

    @Override
    public TMap.Entry<K, V> lastEntry() {
        return this.base.firstEntry();
    }

    @Override
    public TMap.Entry<K, V> pollFirstEntry() {
        return this.base.pollLastEntry();
    }

    @Override
    public TMap.Entry<K, V> pollLastEntry() {
        return this.base.pollFirstEntry();
    }

    @Override
    public V putFirst(K k, V v) {
        return this.base.putLast(k, v);
    }

    @Override
    public V putLast(K k, V v) {
        return this.base.putFirst(k, v);
    }

    @Override
    public TSequencedSet<K> sequencedKeySet() {
        return new TLinkedHashMapKeySet<K>(this.base, true);
    }

    @Override
    public TSequencedCollection<V> sequencedValues() {
        return new TLinkedHashMapValues<V>(this.base, true);
    }

    @Override
    public TSequencedSet<TMap.Entry<K, V>> sequencedEntrySet() {
        return new TLinkedHashMapEntrySet<K, V>(this.base, true);
    }
}

