/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TAbstractList;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TComparator;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TRandomAccess;
import org.teavm.classlib.java.util.function.TUnaryOperator;
import org.teavm.interop.Rename;

public class TArrayList<E>
extends TAbstractList<E>
implements TCloneable,
TSerializable,
TRandomAccess {
    private E[] array;
    private int size;

    public TArrayList() {
        this(10);
    }

    public TArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new Object[initialCapacity];
    }

    public TArrayList(TCollection<? extends E> c) {
        this(c.size());
        TIterator iter = c.iterator();
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = iter.next();
        }
        this.size = this.array.length;
    }

    public void trimToSize() {
        this.array = Arrays.copyOf(this.array, this.size);
    }

    public void ensureCapacity(int minCapacity) {
        if (this.array.length < minCapacity) {
            int newLength = this.array.length < 0x3FFFFFFF ? Math.max(minCapacity, Math.max(this.array.length * 2, 5)) : Integer.MAX_VALUE;
            this.array = TArrays.copyOf(this.array, newLength);
        }
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.array[index];
    }

    @Override
    public E getFirst() {
        this.checkIfNotEmpty();
        return this.array[0];
    }

    @Override
    public E getLast() {
        this.checkIfNotEmpty();
        return this.array[this.size - 1];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Rename(value="clone")
    public TObject clone0() {
        return new TArrayList<E>(this);
    }

    @Override
    public E set(int index, E element) {
        this.checkIndex(index);
        E old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public boolean add(E element) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = element;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkIndexForAdd(index);
        this.ensureCapacity(this.size + 1);
        for (int i = this.size; i > index; --i) {
            this.array[i] = this.array[i - 1];
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public void addFirst(E element) {
        this.add(0, element);
    }

    @Override
    public void addLast(E element) {
        this.add(element);
    }

    @Override
    public E removeFirst() {
        this.checkIfNotEmpty();
        return this.remove(0);
    }

    @Override
    public E removeLast() {
        this.checkIfNotEmpty();
        return this.remove(this.size - 1);
    }

    private void checkIfNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public E remove(int index) {
        this.checkIndex(index);
        E old = this.array[index];
        --this.size;
        for (int i = index; i < this.size; ++i) {
            this.array[i] = this.array[i + 1];
        }
        this.array[this.size] = null;
        ++this.modCount;
        return old;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, 0, this.size, null);
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public boolean addAll(int index, TCollection<? extends E> c) {
        this.checkIndexForAdd(index);
        if (c.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + c.size());
        int gap = c.size();
        for (int i = this.size - 1; i >= index; --i) {
            this.array[i + gap] = this.array[i];
        }
        this.size += gap;
        TIterator iter = c.iterator();
        for (int i = 0; i < gap; ++i) {
            this.array[index++] = iter.next();
        }
        ++this.modCount;
        return true;
    }

    @Override
    protected void removeRange(int start, int end) {
        if (start > end) {
            throw new TIllegalArgumentException();
        }
        if (start < 0 || end > this.size) {
            throw new TIndexOutOfBoundsException();
        }
        if (start == end) {
            return;
        }
        for (int i = end; i < this.size; ++i) {
            this.array[start++] = this.array[end++];
        }
        Arrays.fill(this.array, start, end, null);
        this.size -= end - start;
        ++this.modCount;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new TIndexOutOfBoundsException();
        }
    }

    private void checkIndexForAdd(int index) {
        if (index < 0 || index > this.size) {
            throw new TIndexOutOfBoundsException();
        }
    }

    @Override
    public void replaceAll(TUnaryOperator<E> operator) {
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = operator.apply(this.array[i]);
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.array[i]);
        }
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int length = this.size - 1;
        StringBuilder buffer = new StringBuilder(this.size * 16);
        buffer.append('[');
        for (int i = 0; i < length; ++i) {
            buffer.append((Object)(this.array[i] == this ? "(this Collection)" : this.array[i])).append(", ");
        }
        buffer.append((Object)(this.array[length] == this ? "(this Collection)" : this.array[length]));
        return buffer.append(']').toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + Objects.hashCode(this.array[i]);
        }
        return result;
    }

    @Override
    public void sort(TComparator<? super E> comp) {
        TArrays.sort(this.array, 0, this.size, comp);
        ++this.modCount;
    }
}

