/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.impl.text.FloatSynthesizer;
import org.teavm.classlib.java.lang.TCharacter;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

public class TFloat
extends TNumber
implements TComparable<TFloat> {
    public static final float POSITIVE_INFINITY = Float.POSITIVE_INFINITY;
    public static final float NEGATIVE_INFINITY = Float.NEGATIVE_INFINITY;
    public static final float NaN = Float.NaN;
    public static final float MAX_VALUE = Float.MAX_VALUE;
    public static final float MIN_VALUE = Float.MIN_NORMAL;
    public static final float MIN_NORMAL = Float.MIN_VALUE;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE = Float.TYPE;
    private final float value;

    public TFloat(float value) {
        this.value = value;
    }

    public TFloat(double value) {
        this((float)value);
    }

    public TFloat(String value) throws TNumberFormatException {
        this(TFloat.parseFloat(value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static TFloat valueOf(float d) {
        return new TFloat(d);
    }

    public static String toString(float d) {
        return new TStringBuilder().append(d).toString();
    }

    @Override
    public String toString() {
        return TFloat.toString(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TFloat && TFloat.equals(this.value, ((TFloat)other).value);
    }

    private static boolean equals(float a, float b) {
        return a != a ? b != b : TFloat.floatToRawIntBits(a) == TFloat.floatToRawIntBits(b);
    }

    @Override
    public int hashCode() {
        return TFloat.hashCode(this.value);
    }

    public static int hashCode(float f) {
        return TFloat.floatToIntBits(f);
    }

    @JSBody(params={"v"}, script="return isNaN(v);")
    @Import(module="teavm", name="isnan")
    @NoSideEffects
    @Unmanaged
    public static native boolean isNaN(float var0);

    @JSBody(params={"v"}, script="return !isFinite(v);")
    @Import(module="teavm", name="isinf")
    @NoSideEffects
    @Unmanaged
    public static native boolean isInfinite(float var0);

    @JSBody(params={"v"}, script="return isFinite(v);")
    @Import(module="teavm", name="isfinite")
    @NoSideEffects
    @Unmanaged
    public static native boolean isFinite(float var0);

    public static float parseFloat(String string) throws NumberFormatException {
        if (string.isEmpty()) {
            throw new NumberFormatException();
        }
        int start = 0;
        int end = string.length();
        while (string.charAt(start) <= ' ') {
            if (++start != end) continue;
            throw new NumberFormatException();
        }
        while (string.charAt(end - 1) <= ' ') {
            --end;
        }
        boolean negative = false;
        int index = start;
        if (string.charAt(index) == '-') {
            ++index;
            negative = true;
        } else if (string.charAt(index) == '+') {
            ++index;
        }
        if (index == end) {
            throw new NumberFormatException();
        }
        char c = string.charAt(index);
        int mantissa = 0;
        int exp = -1;
        int mantissaPos = 100000000;
        boolean hasOneDigit = false;
        if (c != '.') {
            hasOneDigit = true;
            if (c < '0' || c > '9') {
                throw new NumberFormatException();
            }
            while (index < end && string.charAt(index) == '0') {
                ++index;
            }
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissaPos > 0) {
                    mantissa += mantissaPos * (c - 48);
                    mantissaPos = Integer.divideUnsigned(mantissaPos, 10);
                }
                ++exp;
                ++index;
            }
        }
        if (index < end && string.charAt(index) == '.') {
            ++index;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                if (mantissa == 0 && c == '0') {
                    --exp;
                } else if (mantissaPos > 0) {
                    mantissa += mantissaPos * (c - 48);
                    mantissaPos = Integer.divideUnsigned(mantissaPos, 10);
                }
                ++index;
                hasOneDigit = true;
            }
            if (!hasOneDigit) {
                throw new NumberFormatException();
            }
        }
        if (index < end) {
            c = string.charAt(index);
            if (c != 'e' && c != 'E') {
                throw new NumberFormatException();
            }
            boolean negativeExp = false;
            if (++index == end) {
                throw new NumberFormatException();
            }
            if (string.charAt(index) == '-') {
                ++index;
                negativeExp = true;
            } else if (string.charAt(index) == '+') {
                ++index;
            }
            int numExp = 0;
            hasOneDigit = false;
            while (index < end && (c = string.charAt(index)) >= '0' && c <= '9') {
                numExp = 10 * numExp + (c - 48);
                hasOneDigit = true;
                ++index;
            }
            if (!hasOneDigit) {
                throw new NumberFormatException();
            }
            if (negativeExp) {
                numExp = -numExp;
            }
            exp += numExp;
        }
        return FloatSynthesizer.synthesizeFloat(mantissa, exp, negative);
    }

    public static TFloat valueOf(String s) throws TNumberFormatException {
        return TFloat.valueOf(TFloat.parseFloat(s));
    }

    public boolean isNaN() {
        return TFloat.isNaN(this.value);
    }

    public boolean isInfinite() {
        return TFloat.isInfinite(this.value);
    }

    @NoSideEffects
    public static int compare(float a, float b) {
        int diff = (a > b ? 1 : 0) - (b > a ? 1 : 0);
        return diff != 0 ? diff : (1.0f / a > 1.0f / b ? 1 : 0) - (1.0f / b > 1.0f / a ? 1 : 0) + (b == b ? 1 : 0) - (a == a ? 1 : 0);
    }

    @Override
    public int compareTo(TFloat other) {
        return TFloat.compare(this.value, other.value);
    }

    @JSBody(params={"value"}, script="return $rt_floatToRawIntBits(value);")
    @Import(name="teavm_reinterpretFloatToInt")
    @NoSideEffects
    @Unmanaged
    public static native int floatToRawIntBits(float var0);

    public static int floatToIntBits(float value) {
        if (TFloat.isNaN(value)) {
            return 2143289344;
        }
        return TFloat.floatToRawIntBits(value);
    }

    @JSBody(params={"bits"}, script="return $rt_intBitsToFloat(bits);")
    @Import(name="teavm_reinterpretIntToFloat")
    @NoSideEffects
    @Unmanaged
    public static native float intBitsToFloat(int var0);

    public static String toHexString(float f) {
        if (TFloat.isNaN(f)) {
            return "NaN";
        }
        if (TFloat.isInfinite(f)) {
            return f > 0.0f ? "Infinity" : "-Infinity";
        }
        char[] buffer = new char[18];
        int sz = 0;
        int bits = TFloat.floatToIntBits(f);
        boolean subNormal = false;
        boolean negative = (bits & Integer.MIN_VALUE) != 0;
        int exp = (bits >>> 23 & 0xFF) - 127;
        int mantissa = (bits & 0x7FFFFF) << 1;
        if (exp == -127) {
            if (mantissa == 0) {
                return negative ? "-0x0.0p0" : "0x0.0p0";
            }
            ++exp;
            subNormal = true;
        }
        for (int i = 0; i < 6; ++i) {
            int digit = mantissa & 0xF;
            if (digit > 0 || sz > 0) {
                buffer[sz++] = TCharacter.forDigit(digit, 16);
            }
            mantissa >>>= 4;
        }
        if (sz == 0) {
            buffer[sz++] = 48;
        }
        buffer[sz++] = 46;
        buffer[sz++] = subNormal ? 48 : 49;
        buffer[sz++] = 120;
        buffer[sz++] = 48;
        if (negative) {
            buffer[sz++] = 45;
        }
        int half = sz / 2;
        for (int i = 0; i < half; ++i) {
            char tmp = buffer[i];
            buffer[i] = buffer[sz - i - 1];
            buffer[sz - i - 1] = tmp;
        }
        buffer[sz++] = 112;
        if (exp < 0) {
            exp = -exp;
            buffer[sz++] = 45;
        }
        int pos = 100;
        boolean first = true;
        for (int i = 0; i < 3; ++i) {
            int digit = exp / pos;
            if (digit > 0 || !first) {
                buffer[sz++] = TCharacter.forDigit(digit, 10);
                first = false;
            }
            exp %= pos;
            pos /= 10;
        }
        if (first) {
            buffer[sz++] = 48;
        }
        return new String(buffer, 0, sz);
    }
}

