/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.zone;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.teavm.classlib.impl.tz.DateTimeZone;
import org.teavm.classlib.impl.tz.DateTimeZoneProvider;
import org.threeten.bp.zone.ZoneRules;
import org.threeten.bp.zone.ZoneRulesException;
import org.threeten.bp.zone.ZoneRulesProvider;

class JodaRulesProvider
extends ZoneRulesProvider {
    private Set<String> zoneIds;
    private Map<String, ZoneRules> cache = new HashMap<String, ZoneRules>();

    JodaRulesProvider() {
    }

    @Override
    protected Set<String> provideZoneIds() {
        if (this.zoneIds == null) {
            this.zoneIds = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(DateTimeZoneProvider.getIds())));
        }
        return this.zoneIds;
    }

    @Override
    protected ZoneRules provideRules(String regionId, boolean forCaching) {
        ZoneRules result = this.cache.get(regionId);
        if (result == null) {
            DateTimeZone zone = DateTimeZoneProvider.getTimeZone(regionId);
            if (zone == null) {
                throw new ZoneRulesException(regionId);
            }
            result = (ZoneRules)((Object)zone.asZoneRules());
            this.cache.put(regionId, result);
        }
        return result;
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        ZoneRules result = this.provideRules(zoneId, false);
        TreeMap<String, ZoneRules> map = new TreeMap<String, ZoneRules>();
        map.put("", result);
        return map;
    }
}

