/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent.atomic;

import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.reflect.TField;
import org.teavm.classlib.java.util.concurrent.atomic.TAtomicReferenceFieldUpdater;

class TReflectionBasedAtomicReferenceFieldUpdater<T, V>
extends TAtomicReferenceFieldUpdater<T, V> {
    private TField field;

    TReflectionBasedAtomicReferenceFieldUpdater(TField field) {
        this.field = field;
    }

    @Override
    public boolean compareAndSet(T obj, V expect, V update) {
        this.checkInstance(obj);
        if (this.field.getWithoutCheck(obj) != expect) {
            return false;
        }
        this.field.setWithoutCheck(obj, update);
        return true;
    }

    @Override
    public boolean weakCompareAndSet(T obj, V expect, V update) {
        return this.compareAndSet(obj, expect, update);
    }

    @Override
    public void set(T obj, V newValue) {
        this.checkInstance(obj);
        this.field.setWithoutCheck(obj, newValue);
    }

    @Override
    public void lazySet(T obj, V newValue) {
        this.set(obj, newValue);
    }

    @Override
    public V get(T obj) {
        this.checkInstance(obj);
        return (V)this.field.getWithoutCheck(obj);
    }

    private void checkInstance(T obj) {
        if (!this.field.getDeclaringClass().isInstance((TObject)obj)) {
            throw new ClassCastException();
        }
    }
}

