/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.teavm.classlib.java.util.zip.TCRC32;
import org.teavm.classlib.java.util.zip.TInflater;
import org.teavm.classlib.java.util.zip.TInflaterInputStream;

public class TGZIPInputStream
extends TInflaterInputStream {
    private static final int FCOMMENT = 16;
    private static final int FEXTRA = 4;
    private static final int FHCRC = 2;
    private static final int FNAME = 8;
    public static final int GZIP_MAGIC = 35615;
    protected TCRC32 crc = new TCRC32();
    protected boolean eos;

    public TGZIPInputStream(InputStream is) throws IOException {
        this(is, 512);
    }

    public TGZIPInputStream(InputStream is, int size) throws IOException {
        super(is, new TInflater(true), size);
        boolean hcrc;
        byte[] header = new byte[10];
        this.readFully(header, 0, header.length);
        if (this.getShort(header, 0) != 35615) {
            throw new IOException();
        }
        byte flags = header[3];
        boolean bl = hcrc = (flags & 2) != 0;
        if (hcrc) {
            this.crc.update(header, 0, header.length);
        }
        if ((flags & 4) != 0) {
            int result;
            this.readFully(header, 0, 2);
            if (hcrc) {
                this.crc.update(header, 0, 2);
            }
            for (int length = this.getShort(header, 0); length > 0; length -= result) {
                int max = length > this.buf.length ? this.buf.length : length;
                result = this.in.read(this.buf, 0, max);
                if (result == -1) {
                    throw new EOFException();
                }
                if (!hcrc) continue;
                this.crc.update(this.buf, 0, result);
            }
        }
        if ((flags & 8) != 0) {
            this.readZeroTerminated(hcrc);
        }
        if ((flags & 0x10) != 0) {
            this.readZeroTerminated(hcrc);
        }
        if (hcrc) {
            this.readFully(header, 0, 2);
            int crc16 = this.getShort(header, 0);
            if ((this.crc.getValue() & 0xFFFFL) != (long)crc16) {
                throw new IOException();
            }
            this.crc.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.eos = true;
        super.close();
    }

    private long getLong(byte[] buffer, int off) {
        long l = 0L;
        l |= (long)(buffer[off] & 0xFF);
        l |= (long)((buffer[off + 1] & 0xFF) << 8);
        l |= (long)((buffer[off + 2] & 0xFF) << 16);
        return l |= (long)(buffer[off + 3] & 0xFF) << 24;
    }

    private int getShort(byte[] buffer, int off) {
        return buffer[off] & 0xFF | (buffer[off + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int off, int nbytes) throws IOException {
        int bytesRead;
        if (this.closed) {
            throw new IOException();
        }
        if (this.eos) {
            return -1;
        }
        if (off > buffer.length || nbytes < 0 || off < 0 || buffer.length - off < nbytes) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            bytesRead = super.read(buffer, off, nbytes);
        }
        finally {
            this.eos = this.eof;
        }
        if (bytesRead != -1) {
            this.crc.update(buffer, off, bytesRead);
        }
        if (this.eos) {
            this.verifyCrc();
        }
        return bytesRead;
    }

    private void verifyCrc() throws IOException {
        int size = this.inf.getRemaining();
        int trailerSize = 8;
        byte[] b = new byte[8];
        int copySize = size > 8 ? 8 : size;
        System.arraycopy(this.buf, this.len - size, b, 0, copySize);
        this.readFully(b, copySize, 8 - copySize);
        if (this.getLong(b, 0) != this.crc.getValue()) {
            throw new IOException();
        }
        if ((int)this.getLong(b, 4) != this.inf.getTotalOut()) {
            throw new IOException();
        }
    }

    private void readFully(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int result = this.in.read(buffer, offset, length);
            if (result == -1) {
                throw new EOFException();
            }
            offset += result;
            length -= result;
        }
    }

    private void readZeroTerminated(boolean hcrc) throws IOException {
        int result;
        while ((result = this.in.read()) > 0) {
            if (!hcrc) continue;
            this.crc.update(result);
        }
        if (result == -1) {
            throw new EOFException();
        }
        if (hcrc) {
            this.crc.update(result);
        }
    }
}

