/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import org.teavm.classlib.java.util.TTemplateCollections;
import org.teavm.classlib.java.util.stream.TBaseStream;
import org.teavm.classlib.java.util.stream.TCollector;
import org.teavm.classlib.java.util.stream.TDoubleStream;
import org.teavm.classlib.java.util.stream.TIntStream;
import org.teavm.classlib.java.util.stream.TLongStream;
import org.teavm.classlib.java.util.stream.impl.TArrayStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TEmptyStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TGenerateStream;
import org.teavm.classlib.java.util.stream.impl.TGenericConcatStream;
import org.teavm.classlib.java.util.stream.impl.TIterateStream;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TSingleStreamImpl;
import org.teavm.classlib.java.util.stream.impl.TSpecializedConcatStream;
import org.teavm.classlib.java.util.stream.impl.TStreamBuilder;

public interface TStream<T>
extends TBaseStream<T, TStream<T>> {
    public TStream<T> filter(Predicate<? super T> var1);

    public <R> TStream<R> map(Function<? super T, ? extends R> var1);

    public TIntStream mapToInt(ToIntFunction<? super T> var1);

    public TLongStream mapToLong(ToLongFunction<? super T> var1);

    public TDoubleStream mapToDouble(ToDoubleFunction<? super T> var1);

    public <R> TStream<R> flatMap(Function<? super T, ? extends TStream<? extends R>> var1);

    public TIntStream flatMapToInt(Function<? super T, ? extends TIntStream> var1);

    public TLongStream flatMapToLong(Function<? super T, ? extends TLongStream> var1);

    public TDoubleStream flatMapToDouble(Function<? super T, ? extends TDoubleStream> var1);

    public TStream<T> distinct();

    public TStream<T> sorted();

    public TStream<T> sorted(Comparator<? super T> var1);

    public TStream<T> peek(Consumer<? super T> var1);

    public TStream<T> limit(long var1);

    public TStream<T> takeWhile(Predicate<? super T> var1);

    public TStream<T> skip(long var1);

    public void forEach(Consumer<? super T> var1);

    public void forEachOrdered(Consumer<? super T> var1);

    public Object[] toArray();

    public <A> A[] toArray(IntFunction<A[]> var1);

    public T reduce(T var1, BinaryOperator<T> var2);

    public Optional<T> reduce(BinaryOperator<T> var1);

    public <U> U reduce(U var1, BiFunction<U, ? super T, U> var2, BinaryOperator<U> var3);

    public <R> R collect(Supplier<R> var1, BiConsumer<R, ? super T> var2, BiConsumer<R, R> var3);

    public <R, A> R collect(TCollector<? super T, A, R> var1);

    public Optional<T> min(Comparator<? super T> var1);

    public Optional<T> max(Comparator<? super T> var1);

    public long count();

    public boolean anyMatch(Predicate<? super T> var1);

    public boolean allMatch(Predicate<? super T> var1);

    public boolean noneMatch(Predicate<? super T> var1);

    public Optional<T> findFirst();

    public Optional<T> findAny();

    public static <T> Builder<T> builder() {
        return new TStreamBuilder();
    }

    public static <T> TStream<T> empty() {
        return new TEmptyStreamImpl();
    }

    public static <T> TStream<T> of(T t) {
        return new TSingleStreamImpl<T>(t);
    }

    @SafeVarargs
    public static <T> TStream<T> of(T ... values) {
        return new TArrayStreamImpl<T>(values, 0, values.length);
    }

    public static <T> TStream<T> iterate(T seed, UnaryOperator<T> f) {
        return new TIterateStream<T>(seed, f);
    }

    public static <T> TStream<T> generate(Supplier<T> s) {
        return new TGenerateStream<T>(s);
    }

    public static <T> TStream<T> concat(TStream<? extends T> a, TStream<? extends T> b) {
        if (a instanceof TSimpleStreamImpl && b instanceof TSimpleStreamImpl) {
            return new TSpecializedConcatStream((TSimpleStreamImpl)a, (TSimpleStreamImpl)b);
        }
        return new TGenericConcatStream<T>(a, b);
    }

    default public List<T> toList() {
        return (List)((Object)new TTemplateCollections.ImmutableArrayList<Object>(this.toArray()));
    }

    public static interface Builder<T> {
        public void accept(T var1);

        default public Builder<T> add(T t) {
            this.accept(t);
            return this;
        }

        public TStream<T> build();
    }
}

