/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.TimeZone;
import org.teavm.backend.c.intrinsic.RuntimeInclude;
import org.teavm.classlib.PlatformDetector;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TSystem;
import org.teavm.interop.Import;
import org.teavm.interop.NoSideEffects;
import org.teavm.interop.Unmanaged;
import org.teavm.interop.UnsupportedOn;
import org.teavm.jso.core.JSDate;

public class TDate
implements TComparable<TDate> {
    private long value;

    @Import(name="teavm_date_init")
    @UnsupportedOn(value={"webassembly"})
    @NoSideEffects
    @Unmanaged
    @RuntimeInclude(value="date.h")
    private static native void initLowLevel();

    public TDate() {
        this.value = TSystem.currentTimeMillis();
    }

    public TDate(long date) {
        this.value = date;
    }

    @Deprecated
    public TDate(int year, int month, int date) {
        this(year, month, date, 0, 0);
    }

    @Deprecated
    public TDate(int year, int month, int date, int hrs, int min) {
        this(year, month, date, hrs, min, 0);
    }

    @Deprecated
    public TDate(int year, int month, int date, int hrs, int min, int sec) {
        this(PlatformDetector.isLowLevel() ? TDate.initDateLowLevel(year, month, date, hrs, min, sec) : (long)JSDate.create((int)year, (int)month, (int)date, (int)hrs, (int)min, (int)sec).getTime());
        if (!PlatformDetector.isLowLevel()) {
            this.setYear(year);
        }
    }

    @Import(name="teavm_date_create")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native long initDateLowLevel(int var0, int var1, int var2, int var3, int var4, int var5);

    public TDate(String s) {
        this(TDate.parse(s));
    }

    public Object clone() {
        return new TDate(this.value);
    }

    @Deprecated
    public static long UTC(int year, int month, int date, int hrs, int min, int sec) {
        if (PlatformDetector.isLowLevel()) {
            return TDate.initUtcDateLowLevel(year, month, date, hrs, min, sec);
        }
        return (long)JSDate.UTC((int)(year + 1900), (int)month, (int)date, (int)hrs, (int)min, (int)sec);
    }

    @Import(name="teavm_date_createUtc")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native long initUtcDateLowLevel(int var0, int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    public static long parse(String s) {
        if (PlatformDetector.isLowLevel()) {
            return TDate.parseLowLevel(s);
        }
        double value = JSDate.parse((String)s);
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Can't parse date: " + s);
        }
        return (long)value;
    }

    @Import(name="teavm_date_parse")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native long parseLowLevel(String var0);

    @Deprecated
    public int getYear() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getYearLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getFullYear() - 1900;
    }

    @Import(name="teavm_date_getYear")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int getYearLowLevel(long var0);

    @Deprecated
    public void setYear(int year) {
        if (PlatformDetector.isLowLevel()) {
            this.value = TDate.setYearLowLevel(this.value, year);
            return;
        }
        JSDate date = JSDate.create((double)this.value);
        date.setFullYear(year + 1900);
        this.value = (long)date.getTime();
    }

    @Import(name="teavm_date_setYear")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native long setYearLowLevel(long var0, int var2);

    @Deprecated
    public int getMonth() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getMonthLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getMonth();
    }

    @Import(name="teavm_date_getMonth")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int getMonthLowLevel(long var0);

    @Deprecated
    public void setMonth(int month) {
        if (PlatformDetector.isLowLevel()) {
            this.value = TDate.setMonthLowLevel(this.value, month);
            return;
        }
        JSDate date = JSDate.create((double)this.value);
        date.setMonth(month);
        this.value = (long)date.getTime();
    }

    @Import(name="teavm_date_setMonth")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native long setMonthLowLevel(long var0, int var2);

    @Deprecated
    public int getDate() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getDateLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getDate();
    }

    @Import(name="teavm_date_getDate")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int getDateLowLevel(long var0);

    @Deprecated
    public void setDate(int date) {
        if (PlatformDetector.isLowLevel()) {
            this.value = TDate.setDateLowLevel(this.value, date);
            return;
        }
        JSDate d = JSDate.create((double)this.value);
        d.setDate(date);
        this.value = (long)d.getTime();
    }

    @Import(name="teavm_date_setDate")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int setDateLowLevel(long var0, int var2);

    @Deprecated
    public int getDay() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getDayLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getDay();
    }

    @Import(name="teavm_date_getDay")
    @UnsupportedOn(value={"webassembly"})
    @Unmanaged
    public static native int getDayLowLevel(long var0);

    @Deprecated
    public int getHours() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getHoursLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getHours();
    }

    @Import(name="teavm_date_getHours")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int getHoursLowLevel(long var0);

    @Deprecated
    public void setHours(int hours) {
        if (PlatformDetector.isLowLevel()) {
            this.value = TDate.setHoursLowLevel(this.value, hours);
            return;
        }
        JSDate date = JSDate.create((double)this.value);
        date.setHours(hours);
        this.value = (long)date.getTime();
    }

    @Import(name="teavm_date_setHours")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int setHoursLowLevel(long var0, int var2);

    @Deprecated
    public int getMinutes() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getMinutesLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getMinutes();
    }

    @Import(name="teavm_date_getMinutes")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int getMinutesLowLevel(long var0);

    @Deprecated
    public void setMinutes(int minutes) {
        if (PlatformDetector.isLowLevel()) {
            this.value = TDate.setMinutesLowLevel(this.value, minutes);
            return;
        }
        JSDate date = JSDate.create((double)this.value);
        date.setMinutes(minutes);
        this.value = (long)date.getTime();
    }

    @Import(name="teavm_date_setMinutes")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int setMinutesLowLevel(long var0, int var2);

    @Deprecated
    public int getSeconds() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.getSecondsLowLevel(this.value);
        }
        return JSDate.create((double)this.value).getSeconds();
    }

    @Import(name="teavm_date_getSeconds")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int getSecondsLowLevel(long var0);

    @Deprecated
    public void setSeconds(int seconds) {
        if (PlatformDetector.isLowLevel()) {
            this.value = TDate.setSecondsLowLevel(this.value, seconds);
            return;
        }
        JSDate date = JSDate.create((double)this.value);
        date.setSeconds(seconds);
        this.value = (long)date.getTime();
    }

    @Import(name="teavm_date_setSeconds")
    @NoSideEffects
    @Unmanaged
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native int setSecondsLowLevel(long var0, int var2);

    public long getTime() {
        return this.value;
    }

    public void setTime(long time) {
        this.value = time;
    }

    public boolean before(TDate when) {
        return this.value < when.value;
    }

    public boolean after(TDate when) {
        return this.value > when.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TDate)) {
            return false;
        }
        TDate other = (TDate)obj;
        return this.value == other.value;
    }

    @Override
    public int compareTo(TDate other) {
        return Long.compare(this.value, other.value);
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public String toString() {
        if (PlatformDetector.isLowLevel()) {
            return TDate.toStringLowLevel(this.value);
        }
        return JSDate.create((double)this.value).stringValue();
    }

    @Import(name="teavm_date_format")
    @NoSideEffects
    @UnsupportedOn(value={"webassembly"})
    @RuntimeInclude(value="date.h")
    private static native String toStringLowLevel(long var0);

    @Deprecated
    public String toLocaleString() {
        return JSDate.create((double)this.value).toLocaleFormat("%c");
    }

    @Deprecated
    public String toGMTString() {
        return JSDate.create((double)this.value).toUTCString();
    }

    @Deprecated
    public int getTimezoneOffset() {
        return -TimeZone.getDefault().getOffset(this.value) / 60000;
    }

    static {
        if (PlatformDetector.isLowLevel()) {
            TDate.initLowLevel();
        }
    }
}

