/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TUnsupportedOperationException;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TListIterator;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TObjects;
import org.teavm.classlib.java.util.TRandomAccess;
import org.teavm.interop.Rename;

public abstract class TAbstractList<E>
extends TAbstractCollection<E>
implements TList<E> {
    protected transient int modCount;

    protected TAbstractList() {
    }

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public TIterator<E> iterator() {
        return new TIterator<E>(){
            private int index;
            private int modCount;
            private int size;
            private int removeIndex;
            {
                this.modCount = TAbstractList.this.modCount;
                this.size = TAbstractList.this.size();
                this.removeIndex = -1;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public E next() {
                this.checkConcurrentModification();
                this.removeIndex = this.index;
                return TAbstractList.this.get(this.index++);
            }

            @Override
            public void remove() {
                if (this.removeIndex < 0) {
                    throw new TIllegalStateException();
                }
                this.checkConcurrentModification();
                TAbstractList.this.remove(this.removeIndex);
                this.modCount = TAbstractList.this.modCount;
                if (this.removeIndex < this.index) {
                    --this.index;
                }
                --this.size;
                this.removeIndex = -1;
            }

            private void checkConcurrentModification() {
                if (this.modCount < TAbstractList.this.modCount) {
                    throw new TConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public boolean addAll(int index, TCollection<? extends E> c) {
        if (index < 0 || index > this.size()) {
            throw new TIllegalArgumentException();
        }
        if (c.isEmpty()) {
            return false;
        }
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
        }
        return true;
    }

    @Override
    public E set(int index, E element) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            Object e = this.get(i);
            if (!(o == null ? e == null : o.equals(e))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            Object e = this.get(i);
            if (!(o == null ? e == null : o.equals(e))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public TListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public TListIterator<E> listIterator(int index) {
        return new TListIteratorImpl(index, this.modCount, this.size());
    }

    @Override
    public TList<E> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new TIllegalArgumentException();
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new TIndexOutOfBoundsException();
        }
        if (this instanceof TRandomAccess) {
            return new SubAbstractListRandomAccess(this, fromIndex, toIndex);
        }
        return new SubAbstractList(this, fromIndex, toIndex);
    }

    protected void removeRange(int start, int end) {
        TListIterator<E> iterator = this.listIterator(start);
        int sz = end - start;
        for (int i = 0; i < sz; ++i) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        TIterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            E elem = iter.next();
            hashCode = 31 * hashCode + (elem != null ? elem.hashCode() : 0);
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals0((TObject)obj);
    }

    @Override
    @Rename(value="equals")
    public boolean equals0(TObject other) {
        if (!(other instanceof TList)) {
            return false;
        }
        TList list = (TList)((Object)other);
        if (this.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (TObjects.equals(this.get(i), list.get(i))) continue;
            return false;
        }
        return true;
    }

    private class TListIteratorImpl
    implements TListIterator<E> {
        private int i;
        private int j;
        private int lastModCount;
        private int sz;

        public TListIteratorImpl(int i, int lastModCount, int sz) {
            this.i = i;
            this.j = i;
            this.lastModCount = lastModCount;
            this.sz = sz;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.sz;
        }

        @Override
        public E next() {
            this.checkConcurrentModification();
            if (this.i == this.sz) {
                throw new TNoSuchElementException();
            }
            this.j = this.i;
            return TAbstractList.this.get(this.i++);
        }

        @Override
        public void remove() {
            if (this.j == -1) {
                throw new TIllegalStateException();
            }
            this.checkConcurrentModification();
            TAbstractList.this.remove(this.j);
            if (this.j < this.i) {
                --this.i;
            }
            --this.sz;
            this.lastModCount = TAbstractList.this.modCount;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public E previous() {
            this.checkConcurrentModification();
            this.j = this.i - 1;
            if (this.j < 0) {
                throw new TNoSuchElementException();
            }
            return TAbstractList.this.get(this.i-- - 1);
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void set(E e) {
            if (this.j == -1) {
                throw new TIllegalStateException();
            }
            this.checkConcurrentModification();
            TAbstractList.this.set(this.j, e);
        }

        @Override
        public void add(E e) {
            TAbstractList.this.add(this.i++, e);
            this.lastModCount = TAbstractList.this.modCount;
            this.j = -1;
        }

        private void checkConcurrentModification() {
            if (this.lastModCount < TAbstractList.this.modCount) {
                throw new TConcurrentModificationException();
            }
        }
    }

    private static final class SubAbstractListRandomAccess<E>
    extends SubAbstractList<E>
    implements TRandomAccess {
        SubAbstractListRandomAccess(TAbstractList<E> list, int start, int end) {
            super(list, start, end);
        }
    }

    private static class SubAbstractList<E>
    extends TAbstractList<E> {
        private final TAbstractList<E> fullList;
        private int offset;
        private int size;

        SubAbstractList(TAbstractList<E> list, int start, int end) {
            this.fullList = list;
            this.modCount = this.fullList.modCount;
            this.offset = start;
            this.size = end - start;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void add(int location, E object) {
            if (this.modCount != this.fullList.modCount) throw new TConcurrentModificationException();
            if (0 > location || location > this.size) throw new TIndexOutOfBoundsException();
            this.fullList.add(location + this.offset, object);
            ++this.size;
            this.modCount = this.fullList.modCount;
        }

        @Override
        public boolean addAll(int location, TCollection<? extends E> collection) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location <= this.size) {
                    boolean result = this.fullList.addAll(location + this.offset, collection);
                    if (result) {
                        this.size += collection.size();
                        this.modCount = this.fullList.modCount;
                    }
                    return result;
                }
                throw new TIndexOutOfBoundsException();
            }
            throw new TConcurrentModificationException();
        }

        @Override
        public boolean addAll(TCollection<? extends E> collection) {
            if (this.modCount == this.fullList.modCount) {
                boolean result = this.fullList.addAll(this.offset + this.size, collection);
                if (result) {
                    this.size += collection.size();
                    this.modCount = this.fullList.modCount;
                }
                return result;
            }
            throw new TConcurrentModificationException();
        }

        @Override
        public E get(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location < this.size) {
                    return this.fullList.get(location + this.offset);
                }
                throw new IndexOutOfBoundsException();
            }
            throw new TConcurrentModificationException();
        }

        @Override
        public TIterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public TListIterator<E> listIterator(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location <= this.size) {
                    return new SubAbstractListIterator<E>(this.fullList.listIterator(location + this.offset), this, this.offset, this.size);
                }
                throw new TIndexOutOfBoundsException();
            }
            throw new TConcurrentModificationException();
        }

        @Override
        public E remove(int location) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location < this.size) {
                    E result = this.fullList.remove(location + this.offset);
                    --this.size;
                    this.modCount = this.fullList.modCount;
                    return result;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new TConcurrentModificationException();
        }

        @Override
        protected void removeRange(int start, int end) {
            if (start != end) {
                if (this.modCount == this.fullList.modCount) {
                    this.fullList.removeRange(start + this.offset, end + this.offset);
                    this.size -= end - start;
                    this.modCount = this.fullList.modCount;
                } else {
                    throw new TConcurrentModificationException();
                }
            }
        }

        @Override
        public E set(int location, E object) {
            if (this.modCount == this.fullList.modCount) {
                if (0 <= location && location < this.size) {
                    return this.fullList.set(location + this.offset, object);
                }
                throw new TIndexOutOfBoundsException();
            }
            throw new TConcurrentModificationException();
        }

        @Override
        public int size() {
            if (this.modCount == this.fullList.modCount) {
                return this.size;
            }
            throw new TConcurrentModificationException();
        }

        void sizeChanged(boolean increment) {
            this.size = increment ? ++this.size : --this.size;
            this.modCount = this.fullList.modCount;
        }

        private static final class SubAbstractListIterator<E>
        implements TListIterator<E> {
            private final SubAbstractList<E> subList;
            private final TListIterator<E> iterator;
            private int start;
            private int end;

            SubAbstractListIterator(TListIterator<E> it, SubAbstractList<E> list, int offset, int length) {
                this.iterator = it;
                this.subList = list;
                this.start = offset;
                this.end = this.start + length;
            }

            @Override
            public void add(E object) {
                this.iterator.add(object);
                this.subList.sizeChanged(true);
                ++this.end;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.nextIndex() < this.end;
            }

            @Override
            public boolean hasPrevious() {
                return this.iterator.previousIndex() >= this.start;
            }

            @Override
            public E next() {
                if (this.iterator.nextIndex() < this.end) {
                    return this.iterator.next();
                }
                throw new TNoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.iterator.nextIndex() - this.start;
            }

            @Override
            public E previous() {
                if (this.iterator.previousIndex() >= this.start) {
                    return this.iterator.previous();
                }
                throw new TNoSuchElementException();
            }

            @Override
            public int previousIndex() {
                int previous = this.iterator.previousIndex();
                if (previous >= this.start) {
                    return previous - this.start;
                }
                return -1;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                this.subList.sizeChanged(false);
                --this.end;
            }

            @Override
            public void set(E object) {
                this.iterator.set(object);
            }
        }
    }
}

