/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.text;

import java.util.Arrays;

public final class DoubleAnalyzer {
    private static final int MAX_ABS_DEC_EXP = 330;
    public static final int DECIMAL_PRECISION = 18;
    public static final long DOUBLE_MAX_POS = 100000000000000000L;
    private static long[] mantissa10Table;
    private static int[] exp10Table;

    private DoubleAnalyzer() {
    }

    public static void analyze(double d, Result result) {
        long upperPos;
        long lowerPos;
        int binExponentCorrection;
        int mantissaShift;
        long decMantissa;
        int decExponent;
        long bits = Double.doubleToLongBits(d);
        result.sign = (bits & Long.MIN_VALUE) != 0L;
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        int exponent = (int)(bits >> 52) & 0x7FF;
        if (mantissa == 0L && exponent == 0) {
            result.mantissa = 0L;
            result.exponent = 0;
            return;
        }
        int errorShift = 0;
        if (exponent == 0) {
            mantissa <<= 1;
            while ((mantissa & 0x10000000000000L) == 0L) {
                mantissa <<= 1;
                --exponent;
                ++errorShift;
            }
        } else {
            mantissa |= 0x10000000000000L;
        }
        if ((decExponent = Arrays.binarySearch(exp10Table, exponent)) < 0) {
            decExponent = -decExponent - 2;
        }
        if ((decMantissa = DoubleAnalyzer.mulAndShiftRight(mantissa, mantissa10Table[decExponent], mantissaShift = 12 + (binExponentCorrection = exponent - exp10Table[decExponent]))) >= 1000000000000000000L) {
            binExponentCorrection = exponent - exp10Table[++decExponent];
            mantissaShift = 12 + binExponentCorrection;
            decMantissa = DoubleAnalyzer.mulAndShiftRight(mantissa, mantissa10Table[decExponent], mantissaShift);
        }
        long error = mantissa10Table[decExponent] >>> 63 - mantissaShift - errorShift;
        long upError = error + 1L >> 1;
        long downError = error >> 1;
        if (mantissa == 0x10000000000000L) {
            downError >>= 2;
        }
        if ((decMantissa = (lowerPos = DoubleAnalyzer.findLowerDistanceToZero(decMantissa, downError)) > (upperPos = DoubleAnalyzer.findUpperDistanceToZero(decMantissa, upError)) ? decMantissa / lowerPos * lowerPos : (lowerPos < upperPos ? decMantissa / upperPos * upperPos + upperPos : (decMantissa + upperPos / 2L) / upperPos * upperPos)) >= 1000000000000000000L) {
            ++decExponent;
            decMantissa /= 10L;
        } else if (decMantissa < 100000000000000000L) {
            --decExponent;
            decMantissa *= 10L;
        }
        result.mantissa = decMantissa;
        result.exponent = decExponent - 330;
    }

    private static long findLowerDistanceToZero(long mantissa, long error) {
        long pos;
        for (pos = 10L; pos <= error; pos *= 10L) {
        }
        long mantissaRight = mantissa % pos;
        if (mantissaRight >= error / 2L) {
            pos /= 10L;
        }
        return pos;
    }

    private static long findUpperDistanceToZero(long mantissa, long error) {
        long pos;
        for (pos = 1L; pos <= error; pos *= 10L) {
        }
        long mantissaRight = mantissa % pos;
        if (pos - mantissaRight > error / 2L) {
            pos /= 10L;
        }
        return pos;
    }

    private static long mulAndShiftRight(long a, long b, int shift) {
        long a1 = a & 0xFFFFL;
        long a2 = a >>> 16 & 0xFFFFL;
        long a3 = a >>> 32 & 0xFFFFL;
        long a4 = a >>> 48 & 0xFFFFL;
        long b1 = b & 0xFFFFL;
        long b2 = b >>> 16 & 0xFFFFL;
        long b3 = b >>> 32 & 0xFFFFL;
        long b4 = b >>> 48 & 0xFFFFL;
        long cm = b3 * a1 + b2 * a2 + b1 * a3;
        long c0 = b4 * a1 + b3 * a2 + b2 * a3 + b1 * a4;
        long c1 = b4 * a2 + b3 * a3 + b2 * a4;
        long c2 = b4 * a3 + b3 * a4;
        long c3 = b4 * a4;
        long c = (c3 << 32 + shift) + (c2 << 16 + shift) + (c1 << shift);
        c = shift <= 16 ? (c += c0 >>> 16 - shift) : (c += c0 << shift - 16);
        return c += cm >>> 32 - shift;
    }

    static {
        long decimalMantissaOne;
        mantissa10Table = new long[660];
        exp10Table = new int[660];
        long mantissa = decimalMantissaOne = 8000000000000000000L;
        long remainder = 0L;
        int exponent = 1023;
        for (int i = 0; i < 330; ++i) {
            DoubleAnalyzer.mantissa10Table[i + 330] = Long.divideUnsigned(mantissa, 80L);
            DoubleAnalyzer.exp10Table[i + 330] = exponent;
            mantissa = Long.divideUnsigned(mantissa, 10L);
            remainder = Long.remainderUnsigned(mantissa, 10L);
            while (mantissa <= decimalMantissaOne && (mantissa & Long.MIN_VALUE) == 0L) {
                mantissa <<= 1;
                ++exponent;
                remainder <<= 1;
            }
            mantissa += remainder / 10L;
        }
        long maxMantissa = 0xCCCCCCCCCCCCCCCL;
        mantissa = decimalMantissaOne;
        exponent = 1023;
        for (int i = 0; i < 330; ++i) {
            long nextMantissa = mantissa;
            int shift = 0;
            while (nextMantissa > maxMantissa) {
                nextMantissa >>= 1;
                ++shift;
                --exponent;
            }
            nextMantissa *= 10L;
            if (shift > 0) {
                long shiftedOffPart = mantissa & (long)((1 << shift) - 1);
                nextMantissa += shiftedOffPart * 10L >> shift;
            }
            mantissa = nextMantissa;
            DoubleAnalyzer.mantissa10Table[330 - i - 1] = Long.divideUnsigned(mantissa, 80L);
            DoubleAnalyzer.exp10Table[330 - i - 1] = exponent;
        }
    }

    public static class Result {
        public long mantissa;
        public int exponent;
        public boolean sign;
    }
}

