/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.classlib.ReflectionContext;
import org.teavm.classlib.ReflectionSupplier;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MemberReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ReflectionDependencyListener
extends AbstractDependencyListener {
    private List<ReflectionSupplier> reflectionSuppliers;
    private MethodReference fieldGet = new MethodReference(Field.class, "get", new Class[]{Object.class, Object.class});
    private MethodReference fieldSet = new MethodReference(Field.class, "set", new Class[]{Object.class, Object.class, Void.TYPE});
    private MethodReference newInstance = new MethodReference(Constructor.class, "newInstance", new Class[]{Object[].class, Object.class});
    private MethodReference invokeMethod = new MethodReference(Method.class, "invoke", new Class[]{Object.class, Object[].class, Object.class});
    private MethodReference getFields = new MethodReference(Class.class, "getDeclaredFields", new Class[]{Field[].class});
    private MethodReference getConstructors = new MethodReference(Class.class, "getDeclaredConstructors", new Class[]{Constructor[].class});
    private MethodReference getMethods = new MethodReference(Class.class, "getDeclaredMethods", new Class[]{Method[].class});
    private MethodReference forName = new MethodReference(Class.class, "forName", new Class[]{String.class, Boolean.class, ClassLoader.class, Class.class});
    private MethodReference forNameShort = new MethodReference(Class.class, "forName", new Class[]{String.class, Class.class});
    private MethodReference fieldGetType = new MethodReference(Field.class, "getType", new Class[]{Class.class});
    private MethodReference methodGetReturnType = new MethodReference(Method.class, "getReturnType", new Class[]{Class.class});
    private MethodReference methodGetParameterTypes = new MethodReference(Method.class, "getParameterTypes", new Class[]{Class[].class});
    private MethodReference constructorGetParameterTypes = new MethodReference(Constructor.class, "getParameterTypes", new Class[]{Class[].class});
    private Map<String, Set<String>> accessibleFieldCache = new LinkedHashMap<String, Set<String>>();
    private Map<String, Set<MethodDescriptor>> accessibleMethodCache = new LinkedHashMap<String, Set<MethodDescriptor>>();
    private Set<String> classesWithReflectableFields = new LinkedHashSet<String>();
    private Set<String> classesWithReflectableMethods = new LinkedHashSet<String>();
    private DependencyNode allClasses;
    private DependencyNode typesInReflectableSignaturesNode;

    public ReflectionDependencyListener(List<ReflectionSupplier> reflectionSuppliers) {
        this.reflectionSuppliers = reflectionSuppliers;
    }

    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
        this.typesInReflectableSignaturesNode = agent.createNode();
    }

    public Set<String> getClassesWithReflectableFields() {
        return this.classesWithReflectableFields;
    }

    public Set<String> getClassesWithReflectableMethods() {
        return this.classesWithReflectableMethods;
    }

    public Set<String> getAccessibleFields(String className) {
        return this.accessibleFieldCache.get(className);
    }

    public Set<MethodDescriptor> getAccessibleMethods(String className) {
        return this.accessibleMethodCache.get(className);
    }

    public void classReached(DependencyAgent agent, String className) {
        this.allClasses.propagate(agent.getType(className));
    }

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().equals((Object)this.fieldGet)) {
            this.handleFieldGet(agent, method);
        } else if (method.getReference().equals((Object)this.fieldSet)) {
            this.handleFieldSet(agent, method);
        } else if (method.getReference().equals((Object)this.newInstance)) {
            this.handleNewInstance(agent, method);
        } else if (method.getReference().equals((Object)this.invokeMethod)) {
            this.handleInvoke(agent, method);
        } else if (method.getReference().equals((Object)this.getFields)) {
            method.getVariable(0).getClassValueNode().addConsumer(type -> {
                if (!type.getName().startsWith("[")) {
                    this.classesWithReflectableFields.add(type.getName());
                    ClassReader cls = agent.getClassSource().get(type.getName());
                    if (cls != null) {
                        for (FieldReader field : cls.getFields()) {
                            this.linkType(agent, field.getType());
                        }
                    }
                }
            });
        } else if (method.getReference().equals((Object)this.getConstructors) || method.getReference().equals((Object)this.getMethods)) {
            method.getVariable(0).getClassValueNode().addConsumer(type -> {
                if (!type.getName().startsWith("[")) {
                    this.classesWithReflectableMethods.add(type.getName());
                    ClassReader cls = agent.getClassSource().get(type.getName());
                    if (cls != null) {
                        for (MethodReader reflectableMethod : cls.getMethods()) {
                            this.linkType(agent, reflectableMethod.getResultType());
                            for (ValueType param : reflectableMethod.getParameterTypes()) {
                                this.linkType(agent, param);
                            }
                        }
                    }
                }
            });
        } else if (method.getReference().equals((Object)this.forName) || method.getReference().equals((Object)this.forNameShort)) {
            this.allClasses.connect(method.getResult().getClassValueNode());
        } else if (method.getReference().equals((Object)this.fieldGetType) || method.getReference().equals((Object)this.methodGetReturnType)) {
            method.getResult().propagate(agent.getType("java.lang.Class"));
            this.typesInReflectableSignaturesNode.connect(method.getResult().getClassValueNode());
        } else if (method.getReference().equals((Object)this.methodGetParameterTypes) || method.getReference().equals((Object)this.constructorGetParameterTypes)) {
            method.getResult().getArrayItem().propagate(agent.getType("java.lang.Class"));
            this.typesInReflectableSignaturesNode.connect(method.getResult().getArrayItem().getClassValueNode());
        }
    }

    private void handleFieldGet(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getFields).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<String> accessibleFields = this.getAccessibleFields(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (String fieldName : accessibleFields) {
                FieldReader field = cls.getField(fieldName);
                FieldDependency fieldDep = agent.linkField(field.getReference()).addLocation(location);
                this.propagateGet(agent, field.getType(), fieldDep.getValue(), method.getResult(), location);
                this.linkClassIfNecessary(agent, (MemberReader)field, location);
            }
        });
    }

    private void handleFieldSet(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getFields).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<String> accessibleFields = this.getAccessibleFields(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (String fieldName : accessibleFields) {
                FieldReader field = cls.getField(fieldName);
                FieldDependency fieldDep = agent.linkField(field.getReference()).addLocation(location);
                this.propagateSet(agent, field.getType(), method.getVariable(2), fieldDep.getValue(), location);
                this.linkClassIfNecessary(agent, (MemberReader)field, location);
            }
        });
    }

    private void handleNewInstance(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getConstructors).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<MethodDescriptor> accessibleMethods = this.getAccessibleMethods(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (MethodDescriptor methodDescriptor : accessibleMethods) {
                MethodReader calledMethod = cls.getMethod(methodDescriptor);
                MethodDependency calledMethodDep = agent.linkMethod(calledMethod.getReference()).addLocation(location);
                calledMethodDep.use();
                for (int i = 0; i < calledMethod.parameterCount(); ++i) {
                    this.propagateSet(agent, methodDescriptor.parameterType(i), method.getVariable(1).getArrayItem(), calledMethodDep.getVariable(i + 1), location);
                }
                calledMethodDep.getVariable(0).propagate(reflectedType);
                this.linkClassIfNecessary(agent, (MemberReader)calledMethod, location);
            }
        });
        classValueNode.connect(method.getResult());
    }

    private void handleInvoke(DependencyAgent agent, MethodDependency method) {
        CallLocation location = new CallLocation(method.getReference());
        DependencyNode classValueNode = agent.linkMethod(this.getMethods).addLocation(location).getVariable(0).getClassValueNode();
        classValueNode.addConsumer(reflectedType -> {
            if (reflectedType.getName().startsWith("[")) {
                return;
            }
            Set<MethodDescriptor> accessibleMethods = this.getAccessibleMethods(agent, reflectedType.getName());
            ClassReader cls = agent.getClassSource().get(reflectedType.getName());
            for (MethodDescriptor methodDescriptor : accessibleMethods) {
                MethodReader calledMethod = cls.getMethod(methodDescriptor);
                MethodDependency calledMethodDep = agent.linkMethod(calledMethod.getReference()).addLocation(location);
                calledMethodDep.use();
                for (int i = 0; i < calledMethod.parameterCount(); ++i) {
                    this.propagateSet(agent, methodDescriptor.parameterType(i), method.getVariable(2).getArrayItem(), calledMethodDep.getVariable(i + 1), location);
                }
                this.propagateSet(agent, ValueType.object((String)reflectedType.getName()), method.getVariable(1), calledMethodDep.getVariable(0), location);
                this.propagateGet(agent, calledMethod.getResultType(), calledMethodDep.getResult(), method.getResult(), location);
                this.linkClassIfNecessary(agent, (MemberReader)calledMethod, location);
            }
        });
    }

    private void linkType(DependencyAgent agent, ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            agent.linkClass(className);
            this.typesInReflectableSignaturesNode.propagate(agent.getType(className));
        }
    }

    private void linkClassIfNecessary(DependencyAgent agent, MemberReader member, CallLocation location) {
        if (member.hasModifier(ElementModifier.STATIC)) {
            agent.linkClass(member.getOwnerName()).initClass(location);
        }
    }

    private Set<String> getAccessibleFields(DependencyAgent agent, String className) {
        return this.accessibleFieldCache.computeIfAbsent(className, key -> this.gatherAccessibleFields(agent, (String)key));
    }

    private Set<MethodDescriptor> getAccessibleMethods(DependencyAgent agent, String className) {
        return this.accessibleMethodCache.computeIfAbsent(className, key -> this.gatherAccessibleMethods(agent, (String)key));
    }

    private Set<String> gatherAccessibleFields(DependencyAgent agent, String className) {
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        for (ReflectionSupplier supplier : this.reflectionSuppliers) {
            fields.addAll(supplier.getAccessibleFields(context, className));
        }
        return fields;
    }

    private Set<MethodDescriptor> gatherAccessibleMethods(DependencyAgent agent, String className) {
        ReflectionContextImpl context = new ReflectionContextImpl(agent);
        LinkedHashSet<MethodDescriptor> methods = new LinkedHashSet<MethodDescriptor>();
        for (ReflectionSupplier supplier : this.reflectionSuppliers) {
            methods.addAll(supplier.getAccessibleMethods(context, className));
        }
        return methods;
    }

    private void propagateGet(DependencyAgent agent, ValueType type, DependencyNode sourceNode, DependencyNode targetNode, CallLocation location) {
        if (type instanceof ValueType.Primitive) {
            MethodReference boxMethod;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    boxMethod = new MethodReference(Boolean.class, "valueOf", new Class[]{Boolean.TYPE, Boolean.class});
                    break;
                }
                case BYTE: {
                    boxMethod = new MethodReference(Byte.class, "valueOf", new Class[]{Byte.TYPE, Byte.class});
                    break;
                }
                case SHORT: {
                    boxMethod = new MethodReference(Short.class, "valueOf", new Class[]{Short.TYPE, Short.class});
                    break;
                }
                case CHARACTER: {
                    boxMethod = new MethodReference(Character.class, "valueOf", new Class[]{Character.TYPE, Character.class});
                    break;
                }
                case INTEGER: {
                    boxMethod = new MethodReference(Integer.class, "valueOf", new Class[]{Integer.TYPE, Integer.class});
                    break;
                }
                case FLOAT: {
                    boxMethod = new MethodReference(Float.class, "valueOf", new Class[]{Float.TYPE, Float.class});
                    break;
                }
                case DOUBLE: {
                    boxMethod = new MethodReference(Double.class, "valueOf", new Class[]{Double.TYPE, Double.class});
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.toString());
                }
            }
            MethodDependency boxMethodDep = agent.linkMethod(boxMethod).addLocation(location);
            boxMethodDep.use();
            boxMethodDep.getResult().connect(targetNode);
        } else if (type instanceof ValueType.Array || type instanceof ValueType.Object) {
            sourceNode.connect(targetNode);
        }
    }

    private void propagateSet(DependencyAgent agent, ValueType type, DependencyNode sourceNode, DependencyNode targetNode, CallLocation location) {
        if (type instanceof ValueType.Primitive) {
            MethodReference unboxMethod;
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    unboxMethod = new MethodReference(Boolean.class, "booleanValue", new Class[]{Boolean.TYPE});
                    break;
                }
                case BYTE: {
                    unboxMethod = new MethodReference(Byte.class, "byteValue", new Class[]{Byte.TYPE});
                    break;
                }
                case SHORT: {
                    unboxMethod = new MethodReference(Short.class, "shortValue", new Class[]{Short.TYPE});
                    break;
                }
                case CHARACTER: {
                    unboxMethod = new MethodReference(Character.class, "charValue", new Class[]{Character.TYPE});
                    break;
                }
                case INTEGER: {
                    unboxMethod = new MethodReference(Integer.class, "intValue", new Class[]{Integer.TYPE});
                    break;
                }
                case FLOAT: {
                    unboxMethod = new MethodReference(Float.class, "floatValue", new Class[]{Float.TYPE});
                    break;
                }
                case DOUBLE: {
                    unboxMethod = new MethodReference(Double.class, "doubleOf", new Class[]{Double.TYPE});
                    break;
                }
                default: {
                    throw new AssertionError((Object)type.toString());
                }
            }
            MethodDependency unboxMethodDep = agent.linkMethod(unboxMethod).addLocation(location);
            unboxMethodDep.use();
            sourceNode.connect(unboxMethodDep.getResult());
        } else if (type instanceof ValueType.Array || type instanceof ValueType.Object) {
            sourceNode.connect(targetNode);
        }
    }

    private static class ReflectionContextImpl
    implements ReflectionContext {
        private DependencyAgent agent;

        public ReflectionContextImpl(DependencyAgent agent) {
            this.agent = agent;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.agent.getClassLoader();
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.agent.getClassSource();
        }
    }
}

