/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TBuffer;
import org.teavm.classlib.java.nio.TBufferOverflowException;
import org.teavm.classlib.java.nio.TBufferUnderflowException;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBufferOverArray;
import org.teavm.classlib.java.nio.TReadOnlyBufferException;

public abstract class TIntBuffer
extends TBuffer
implements Comparable<TIntBuffer> {
    TIntBuffer(int capacity, int position, int limit) {
        super(capacity);
        this.position = position;
        this.limit = limit;
    }

    public static TIntBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity is negative: " + capacity);
        }
        return new TIntBufferOverArray(capacity);
    }

    public static TIntBuffer wrap(int[] array, int offset, int length) {
        return new TIntBufferOverArray(0, array.length, array, offset, offset + length, false);
    }

    public static TIntBuffer wrap(int[] array) {
        return TIntBuffer.wrap(array, 0, array.length);
    }

    public abstract TIntBuffer slice();

    public abstract TIntBuffer duplicate();

    public abstract TIntBuffer asReadOnlyBuffer();

    public abstract int get();

    public abstract TIntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract TIntBuffer put(int var1, int var2);

    abstract int getElement(int var1);

    abstract void putElement(int var1, int var2);

    public TIntBuffer get(int[] dst, int offset, int length) {
        if (offset < 0 || offset >= dst.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + dst.length + ")");
        }
        if (offset + length > dst.length) {
            throw new IndexOutOfBoundsException("The last int in dst " + (offset + length) + " is outside " + "of array of size " + dst.length);
        }
        if (this.remaining() < length) {
            throw new TBufferUnderflowException();
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            dst[offset++] = this.getElement(pos++);
        }
        this.position += length;
        return this;
    }

    public TIntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public TIntBuffer put(TIntBuffer src) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < src.remaining()) {
            throw new TBufferOverflowException();
        }
        int length = src.remaining();
        int pos = this.position;
        int offset = src.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src.getElement(offset++));
        }
        this.position += length;
        return this;
    }

    public TIntBuffer put(int[] src, int offset, int length) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.remaining() < length) {
            throw new TBufferOverflowException();
        }
        if (offset < 0 || offset >= src.length) {
            throw new IndexOutOfBoundsException("Offset " + offset + " is outside of range [0;" + src.length + ")");
        }
        if (offset + length > src.length) {
            throw new IndexOutOfBoundsException("The last int in src " + (offset + length) + " is outside " + "of array of size " + src.length);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length " + length + " must be non-negative");
        }
        int pos = this.position;
        for (int i = 0; i < length; ++i) {
            this.putElement(pos++, src[offset++]);
        }
        this.position += length;
        return this;
    }

    public final TIntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.isArrayPresent();
    }

    public final int[] array() {
        return this.getArray();
    }

    @Override
    public final int arrayOffset() {
        return this.getArrayOffset();
    }

    abstract boolean isArrayPresent();

    abstract int[] getArray();

    abstract int getArrayOffset();

    public abstract TIntBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        return "[IntBuffer position=" + this.position + ", limit=" + this.limit + ", capacity=" + this.capacity + ", mark " + (this.mark >= 0 ? " at " + this.mark : " is not set") + "]";
    }

    public int hashCode() {
        int hashCode = 0;
        int pos = this.position;
        for (int i = this.position; i < this.limit; ++i) {
            hashCode = 31 * hashCode + this.getElement(pos++);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TIntBuffer)) {
            return false;
        }
        TIntBuffer other = (TIntBuffer)obj;
        int sz = this.remaining();
        if (sz != other.remaining()) {
            return false;
        }
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            if (this.getElement(a++) == other.getElement(b++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(TIntBuffer other) {
        if (this == other) {
            return 0;
        }
        int sz = Math.min(this.remaining(), other.remaining());
        int a = this.position;
        int b = other.position;
        for (int i = 0; i < sz; ++i) {
            int r;
            if ((r = Integer.compare(this.getElement(a++), other.getElement(b++))) == 0) continue;
            return r;
        }
        return Integer.compare(this.remaining(), other.remaining());
    }

    public abstract TByteOrder order();
}

