/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.classlib.java.io.TConsole;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.io.TPrintStream;
import org.teavm.classlib.java.lang.SystemNativeGenerator;
import org.teavm.classlib.java.lang.TArrayStoreException;
import org.teavm.classlib.java.lang.TConsoleInputStream;
import org.teavm.classlib.java.lang.TConsoleOutputStreamStderr;
import org.teavm.classlib.java.lang.TConsoleOutputStreamStdout;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.reflect.TArray;
import org.teavm.dependency.PluggableDependency;
import org.teavm.interop.Address;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.GC;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;

public final class TSystem
extends TObject {
    public static final TPrintStream out = new TPrintStream(new TConsoleOutputStreamStdout(), false);
    public static final TPrintStream err = new TPrintStream(new TConsoleOutputStreamStderr(), false);
    public static final TInputStream in = new TConsoleInputStream();

    private TSystem() {
    }

    public static TConsole console() {
        return null;
    }

    public static void arraycopy(TObject src, int srcPos, TObject dest, int destPos, int length) {
        if (src == null || dest == null) {
            throw new TNullPointerException(TString.wrap("Either src or dest is null"));
        }
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > TArray.getLength(src) || destPos + length > TArray.getLength(dest)) {
            throw new TIndexOutOfBoundsException();
        }
        if (src != dest) {
            Class<?> srcType = src.getClass().getComponentType();
            Class<?> targetType = dest.getClass().getComponentType();
            if (srcType == null || targetType == null) {
                throw new TArrayStoreException();
            }
            if (srcType != targetType) {
                if (!srcType.isPrimitive() && !targetType.isPrimitive()) {
                    Object[] srcArray = (Object[])src;
                    int pos = srcPos;
                    for (int i = 0; i < length; ++i) {
                        Object elem;
                        if (targetType.isInstance(elem = srcArray[pos++])) continue;
                        TSystem.doArrayCopy(src, srcPos, dest, destPos, i);
                        throw new TArrayStoreException();
                    }
                    TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
                    return;
                }
                if (!srcType.isPrimitive() || !targetType.isPrimitive()) {
                    throw new TArrayStoreException();
                }
            }
        }
        TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @DelegateTo(value="doArrayCopyLowLevel")
    private static native void doArrayCopy(Object var0, int var1, Object var2, int var3, int var4);

    @Unmanaged
    static void doArrayCopyLowLevel(RuntimeArray src, int srcPos, RuntimeArray dest, int destPos, int length) {
        RuntimeClass type = RuntimeClass.getClass((RuntimeObject)src);
        int itemSize = type.itemType.size;
        if ((type.itemType.flags & 2) == 0) {
            itemSize = Address.sizeOf();
        }
        Address srcAddress = Address.align((Address)src.toAddress().add(RuntimeArray.class, 1), (int)itemSize);
        srcAddress = srcAddress.add(itemSize * srcPos);
        Address destAddress = Address.align((Address)dest.toAddress().add(RuntimeArray.class, 1), (int)itemSize);
        destAddress = destAddress.add(itemSize * destPos);
        Allocator.moveMemoryBlock((Address)srcAddress, (Address)destAddress, (int)(length * itemSize));
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @DelegateTo(value="currentTimeMillisLowLevel")
    public static native long currentTimeMillis();

    private static long currentTimeMillisLowLevel() {
        return (long)TSystem.currentTimeMillisImpl();
    }

    @Import(name="currentTimeMillis", module="runtime")
    private static native double currentTimeMillisImpl();

    public static TString getProperty(TString key) {
        return null;
    }

    public static TString getProperty(TString key, TString def) {
        TString value = TSystem.getProperty(key);
        return value != null ? value : def;
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native void setErr(TPrintStream var0);

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native void setOut(TPrintStream var0);

    @DelegateTo(value="gcLowLevel")
    public static void gc() {
    }

    private static void gcLowLevel() {
        GC.collectGarbage((int)0);
    }

    public static void runFinalization() {
    }

    public static long nanoTime() {
        return TSystem.currentTimeMillis() * 1000000L;
    }

    public static int identityHashCode(Object x) {
        return ((TObject)x).identity();
    }

    public static TString lineSeparator() {
        return TString.wrap("\n");
    }
}

