/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalMonitorStateException;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TInterruptedException;
import org.teavm.classlib.java.lang.TThread;
import org.teavm.classlib.java.lang.TThreadInterruptHandler;
import org.teavm.classlib.java.lang.TThrowable;
import org.teavm.interop.Address;
import org.teavm.interop.Async;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.Rename;
import org.teavm.interop.Structure;
import org.teavm.interop.Superclass;
import org.teavm.interop.Sync;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.PlatformQueue;
import org.teavm.platform.PlatformRunnable;
import org.teavm.platform.async.AsyncCallback;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeJavaObject;
import org.teavm.runtime.RuntimeObject;

@Superclass(value="")
public class TObject {
    Monitor monitor;

    static void monitorEnterSync(TObject o) {
        if (o.monitor == null) {
            o.monitor = new Monitor();
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = TThread.currentThread();
        } else if (o.monitor.owner != TThread.currentThread()) {
            throw new IllegalStateException("Can't enter monitor from another thread synchronously");
        }
        ++o.monitor.count;
    }

    static void monitorExitSync(TObject o) {
        if (o.isEmptyMonitor() || o.monitor.owner != TThread.currentThread()) {
            throw new TIllegalMonitorStateException();
        }
        if (--o.monitor.count == 0) {
            o.monitor.owner = null;
        }
        o.isEmptyMonitor();
    }

    static void monitorEnter(TObject o) {
        TObject.monitorEnter(o, 1);
    }

    static void monitorEnter(TObject o, int count) {
        if (o.monitor == null) {
            o.monitor = new Monitor();
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = TThread.currentThread();
        }
        if (o.monitor.owner != TThread.currentThread()) {
            TObject.monitorEnterWait(o, count);
        } else {
            o.monitor.count += count;
        }
    }

    @Async
    static native void monitorEnterWait(TObject var0, int var1);

    static void monitorEnterWait(TObject o, int count, AsyncCallback<Void> callback) {
        TThread thread = TThread.currentThread();
        if (o.monitor == null) {
            o.monitor = new Monitor();
            TThread.setCurrentThread(thread);
            o.monitor.count += count;
            callback.complete(null);
            return;
        }
        if (o.monitor.owner == null) {
            o.monitor.owner = thread;
            TThread.setCurrentThread(thread);
            o.monitor.count += count;
            callback.complete(null);
            return;
        }
        o.monitor.enteringThreads.add(() -> {
            TThread.setCurrentThread(thread);
            o.monitor.owner = thread;
            o.monitor.count += count;
            callback.complete(null);
        });
    }

    @Sync
    static void monitorExit(TObject o) {
        TObject.monitorExit(o, 1);
    }

    @Sync
    static void monitorExit(TObject o, int count) {
        if (o.isEmptyMonitor() || o.monitor.owner != TThread.currentThread()) {
            throw new TIllegalMonitorStateException();
        }
        o.monitor.count -= count;
        if (o.monitor.count > 0) {
            return;
        }
        o.monitor.owner = null;
        if (!o.monitor.enteringThreads.isEmpty()) {
            Platform.postpone(() -> {
                if (o.isEmptyMonitor() || o.monitor.owner != null) {
                    return;
                }
                if (!o.monitor.enteringThreads.isEmpty()) {
                    ((PlatformRunnable)o.monitor.enteringThreads.remove()).run();
                }
            });
        } else {
            o.isEmptyMonitor();
        }
    }

    boolean isEmptyMonitor() {
        if (this.monitor == null) {
            return true;
        }
        if (this.monitor.owner == null && this.monitor.enteringThreads.isEmpty() && this.monitor.notifyListeners.isEmpty()) {
            this.monitor = null;
            return true;
        }
        return false;
    }

    static boolean holdsLock(TObject o) {
        return o.monitor != null && o.monitor.owner == TThread.currentThread();
    }

    @Rename(value="fakeInit")
    public TObject() {
    }

    @Rename(value="<init>")
    private void init() {
    }

    @Rename(value="getClass")
    public final TClass<?> getClass0() {
        return TClass.getClass(Platform.getPlatformObject((Object)this).getPlatformClass());
    }

    public int hashCode() {
        return this.identity();
    }

    @Rename(value="equals")
    public boolean equals0(TObject other) {
        return this == other;
    }

    public String toString() {
        return this.getClass().getName() + "@" + TInteger.toHexString(this.identity());
    }

    @DelegateTo(value="identityLowLevel")
    int identity() {
        PlatformObject platformThis = Platform.getPlatformObject((Object)this);
        if (platformThis.getId() == 0) {
            platformThis.setId(Platform.nextObjectId());
        }
        return Platform.getPlatformObject((Object)this).getId();
    }

    private static int identityLowLevel(RuntimeJavaObject object) {
        int result;
        if ((object.classReference & 0x20000000) != 0) {
            object = (RuntimeJavaObject)object.monitor;
        }
        if ((result = object.monitor.toAddress().toInt()) == 0) {
            if ((result = RuntimeJavaObject.nextId++) == 0) {
                result = RuntimeJavaObject.nextId++;
            }
            object.monitor = (RuntimeObject)Address.fromInt((int)result).toStructure();
        }
        return result;
    }

    @DelegateTo(value="cloneLowLevel")
    protected Object clone() throws TCloneNotSupportedException {
        if (!(this instanceof TCloneable) && Platform.getPlatformObject((Object)this).getPlatformClass().getMetadata().getArrayItem() == null) {
            throw new TCloneNotSupportedException();
        }
        Object result = Platform.clone((Object)this);
        Platform.getPlatformObject((Object)result).setId(Platform.nextObjectId());
        return result;
    }

    private static RuntimeJavaObject cloneLowLevel(RuntimeJavaObject self) {
        int size;
        RuntimeJavaObject copy;
        RuntimeClass cls = RuntimeClass.getClass((RuntimeObject)self);
        int skip = Structure.sizeOf(RuntimeJavaObject.class);
        if (cls.itemType == null) {
            copy = (RuntimeJavaObject)Allocator.allocate((RuntimeClass)cls).toStructure();
            size = cls.size;
        } else {
            RuntimeArray array = (RuntimeArray)self;
            copy = (RuntimeJavaObject)Allocator.allocateArray((RuntimeClass)cls, (int)array.size).toStructure();
            int itemSize = (cls.itemType.flags & 2) == 0 ? 4 : cls.itemType.size;
            Address headerSize = Address.align((Address)Address.fromInt((int)Structure.sizeOf(RuntimeArray.class)), (int)itemSize);
            size = itemSize * array.size + headerSize.toInt();
        }
        if (size > skip) {
            Allocator.moveMemoryBlock((Address)self.toAddress().add(skip), (Address)copy.toAddress().add(skip), (int)(size - skip));
        }
        return copy;
    }

    @Sync
    @Rename(value="notify")
    public final void notify0() {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        PlatformQueue<NotifyListener> listeners = this.monitor.notifyListeners;
        while (!listeners.isEmpty()) {
            NotifyListener listener = (NotifyListener)listeners.remove();
            if (listener.expired()) continue;
            Platform.postpone((PlatformRunnable)listener);
            break;
        }
    }

    @Sync
    @Rename(value="notifyAll")
    public final void notifyAll0() {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        PlatformQueue<NotifyListener> listeners = this.monitor.notifyListeners;
        while (!listeners.isEmpty()) {
            NotifyListener listener = (NotifyListener)listeners.remove();
            if (listener.expired()) continue;
            Platform.postpone((PlatformRunnable)listener);
        }
    }

    @Rename(value="wait")
    public final void wait0(long timeout) throws TInterruptedException {
        try {
            this.wait(timeout, 0);
        }
        catch (InterruptedException ex) {
            throw new TInterruptedException();
        }
    }

    @Rename(value="wait")
    private void wait0(long timeout, int nanos) throws TInterruptedException {
        if (!TObject.holdsLock(this)) {
            throw new TIllegalMonitorStateException();
        }
        this.waitImpl(timeout, nanos);
    }

    @Async
    private native void waitImpl(long var1, int var3) throws TInterruptedException;

    public final void waitImpl(long timeout, int nanos, AsyncCallback<Void> callback) {
        NotifyListenerImpl listener = new NotifyListenerImpl(this, callback, this.monitor.count);
        this.monitor.notifyListeners.add((Object)listener);
        if (timeout > 0L || nanos > 0) {
            listener.timerId = Platform.schedule((PlatformRunnable)listener, (int)(timeout >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeout));
        }
        TObject.monitorExit(this, this.monitor.count);
    }

    @Rename(value="wait")
    public final void wait0() throws TInterruptedException {
        try {
            this.wait(0L);
        }
        catch (InterruptedException ex) {
            throw new TInterruptedException();
        }
    }

    protected void finalize() throws TThrowable {
    }

    public static TObject wrap(Object obj) {
        return (TObject)obj;
    }

    private static class NotifyListenerImpl
    implements NotifyListener,
    TimerHandler,
    PlatformRunnable,
    TThreadInterruptHandler {
        final TObject obj;
        final AsyncCallback<Void> callback;
        final TThread currentThread = TThread.currentThread();
        int timerId = -1;
        boolean expired;
        boolean performed;
        int lockCount;

        public NotifyListenerImpl(TObject obj, AsyncCallback<Void> callback, int lockCount) {
            this.obj = obj;
            this.callback = callback;
            this.lockCount = lockCount;
        }

        @Override
        public boolean expired() {
            boolean result = this.expired;
            this.expired = true;
            return result;
        }

        public void onTimer() {
            Platform.postpone(() -> {
                if (!this.expired()) {
                    this.run();
                }
            });
        }

        public void run() {
            if (this.performed) {
                return;
            }
            this.performed = true;
            if (this.timerId >= 0) {
                Platform.killSchedule((int)this.timerId);
                this.timerId = -1;
            }
            TThread.setCurrentThread(this.currentThread);
            TObject.monitorEnterWait(this.obj, this.lockCount, this.callback);
        }

        @Override
        public void interrupted() {
            if (this.performed) {
                return;
            }
            this.performed = true;
            if (this.timerId >= 0) {
                Platform.killSchedule((int)this.timerId);
                this.timerId = -1;
            }
            Platform.postpone(() -> this.callback.error((Throwable)new TInterruptedException()));
        }
    }

    static interface NotifyListener
    extends PlatformRunnable {
        public boolean expired();
    }

    static class Monitor {
        PlatformQueue<PlatformRunnable> enteringThreads;
        PlatformQueue<NotifyListener> notifyListeners;
        TThread owner = TThread.currentThread();
        int count;

        public Monitor() {
            this.enteringThreads = Platform.createQueue();
            this.notifyListeners = Platform.createQueue();
        }
    }
}

