/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import org.teavm.classlib.java.io.TFilterInputStream;
import org.teavm.classlib.java.io.TIOException;
import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.lang.TString;

public class TBufferedInputStream
extends TFilterInputStream {
    protected volatile byte[] buf;
    protected int count;
    protected int marklimit;
    protected int markpos = -1;
    protected int pos;

    public TBufferedInputStream(TInputStream in) {
        super(in);
        this.buf = new byte[8192];
    }

    public TBufferedInputStream(TInputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Size " + size + " is negative");
        }
        this.buf = new byte[size];
    }

    @Override
    public int available() throws TIOException {
        TInputStream localIn = this.in;
        if (this.buf == null || localIn == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        return this.count - this.pos + localIn.available();
    }

    @Override
    public void close() throws TIOException {
        this.buf = null;
        TInputStream localIn = this.in;
        this.in = null;
        if (localIn != null) {
            localIn.close();
        }
    }

    private int fillbuf(TInputStream localIn, byte[] localBuf) throws TIOException {
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int result = localIn.read(localBuf);
            if (result > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = result;
            }
            return result;
        }
        if (this.markpos == 0 && this.marklimit > localBuf.length) {
            int newLength = localBuf.length * 2;
            if (newLength > this.marklimit) {
                newLength = this.marklimit;
            }
            byte[] newbuf = new byte[newLength];
            System.arraycopy(localBuf, 0, newbuf, 0, localBuf.length);
            this.buf = newbuf;
            localBuf = this.buf;
        } else if (this.markpos > 0) {
            System.arraycopy(localBuf, this.markpos, localBuf, 0, localBuf.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.count = 0;
        this.markpos = 0;
        int bytesread = localIn.read(localBuf, this.pos, localBuf.length - this.pos);
        this.count = bytesread <= 0 ? this.pos : this.pos + bytesread;
        return bytesread;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws TIOException {
        byte[] localBuf = this.buf;
        TInputStream localIn = this.in;
        if (localBuf == null || localIn == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (this.pos >= this.count && this.fillbuf(localIn, localBuf) == -1) {
            return -1;
        }
        if (localBuf != this.buf && (localBuf = this.buf) == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (this.count - this.pos > 0) {
            return localBuf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int length) throws TIOException {
        int required;
        byte[] localBuf = this.buf;
        if (localBuf == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (offset > buffer.length - length || offset < 0 || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        TInputStream localIn = this.in;
        if (localIn == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (this.pos < this.count) {
            int copylength = this.count - this.pos >= length ? length : this.count - this.pos;
            System.arraycopy(localBuf, this.pos, buffer, offset, copylength);
            this.pos += copylength;
            if (copylength == length || localIn.available() == 0) {
                return copylength;
            }
            offset += copylength;
            required = length - copylength;
        } else {
            required = length;
        }
        while (true) {
            int read;
            if (this.markpos == -1 && required >= localBuf.length) {
                read = localIn.read(buffer, offset, required);
                if (read == -1) {
                    return required == length ? -1 : length - required;
                }
            } else {
                if (this.fillbuf(localIn, localBuf) == -1) {
                    return required == length ? -1 : length - required;
                }
                if (localBuf != this.buf && (localBuf = this.buf) == null) {
                    throw new TIOException(TString.wrap("Stream is closed"));
                }
                read = this.count - this.pos >= required ? required : this.count - this.pos;
                System.arraycopy(localBuf, this.pos, buffer, offset, read);
                this.pos += read;
            }
            if ((required -= read) == 0) {
                return length;
            }
            if (localIn.available() == 0) {
                return length - required;
            }
            offset += read;
        }
    }

    @Override
    public synchronized void reset() throws TIOException {
        if (this.buf == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (-1 == this.markpos) {
            throw new TIOException(TString.wrap("Mark has been invalidated."));
        }
        this.pos = this.markpos;
    }

    @Override
    public synchronized long skip(long amount) throws TIOException {
        byte[] localBuf = this.buf;
        TInputStream localIn = this.in;
        if (localBuf == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if (amount < 1L) {
            return 0L;
        }
        if (localIn == null) {
            throw new TIOException(TString.wrap("Stream is closed"));
        }
        if ((long)(this.count - this.pos) >= amount) {
            this.pos = (int)((long)this.pos + amount);
            return amount;
        }
        long read = this.count - this.pos;
        this.pos = this.count;
        if (this.markpos != -1 && amount <= (long)this.marklimit) {
            if (this.fillbuf(localIn, localBuf) == -1) {
                return read;
            }
            if ((long)(this.count - this.pos) >= amount - read) {
                this.pos = (int)((long)this.pos + (amount - read));
                return amount;
            }
            this.pos = this.count;
            return read += (long)(this.count - this.pos);
        }
        return read + localIn.skip(amount - read);
    }
}

