/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import java.util.BitSet;
import java.util.MissingResourceException;
import org.teavm.classlib.java.util.regex.TCharClass;
import org.teavm.classlib.java.util.regex.TSpecialToken;
import org.teavm.classlib.java.util.regex.TUnicodeCategory;
import org.teavm.classlib.java.util.regex.TUnicodeCategoryScope;

abstract class TAbstractCharClass
extends TSpecialToken {
    protected boolean alt;
    protected boolean altSurrogates;
    static final int SURROGATE_CARDINALITY = 2048;
    BitSet lowHighSurrogates = new BitSet(2048);
    TAbstractCharClass charClassWithoutSurrogates;
    TAbstractCharClass charClassWithSurrogates;
    static PredefinedCharacterClasses charClasses = new PredefinedCharacterClasses();
    protected boolean mayContainSupplCodepoints;

    TAbstractCharClass() {
    }

    public abstract boolean contains(int var1);

    protected BitSet getBits() {
        return null;
    }

    protected BitSet getLowHighSurrogates() {
        return this.lowHighSurrogates;
    }

    public boolean hasLowHighSurrogates() {
        return this.altSurrogates ? this.lowHighSurrogates.nextClearBit(0) < 2048 : this.lowHighSurrogates.nextSetBit(0) < 2048;
    }

    public boolean mayContainSupplCodepoints() {
        return this.mayContainSupplCodepoints;
    }

    @Override
    public int getType() {
        return 1;
    }

    public TAbstractCharClass getInstance() {
        return this;
    }

    public TAbstractCharClass getSurrogates() {
        if (this.charClassWithSurrogates == null) {
            final BitSet lHS = this.getLowHighSurrogates();
            this.charClassWithSurrogates = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    int index = ch - 55296;
                    return index >= 0 && index < 2048 ? this.altSurrogates ^ lHS.get(index) : false;
                }
            };
            this.charClassWithSurrogates.setNegative(this.altSurrogates);
        }
        return this.charClassWithSurrogates;
    }

    public TAbstractCharClass getWithoutSurrogates() {
        if (this.charClassWithoutSurrogates == null) {
            final BitSet lHS = this.getLowHighSurrogates();
            final TAbstractCharClass thisClass = this;
            this.charClassWithoutSurrogates = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    int index = ch - 55296;
                    boolean containslHS = index >= 0 && index < 2048 ? this.altSurrogates ^ lHS.get(index) : false;
                    return thisClass.contains(ch) && !containslHS;
                }
            };
            this.charClassWithoutSurrogates.setNegative(this.isNegative());
            this.charClassWithoutSurrogates.mayContainSupplCodepoints = this.mayContainSupplCodepoints;
        }
        return this.charClassWithoutSurrogates;
    }

    public boolean hasUCI() {
        return false;
    }

    public TAbstractCharClass setNegative(boolean value) {
        if (this.alt ^ value) {
            this.alt = !this.alt;
            boolean bl = this.altSurrogates = !this.altSurrogates;
        }
        if (!this.mayContainSupplCodepoints) {
            this.mayContainSupplCodepoints = true;
        }
        return this;
    }

    public boolean isNegative() {
        return this.alt;
    }

    public static boolean intersects(int ch1, int ch2) {
        return ch1 == ch2;
    }

    public static boolean intersects(TAbstractCharClass cc, int ch) {
        return cc.contains(ch);
    }

    public static boolean intersects(TAbstractCharClass cc1, TAbstractCharClass cc2) {
        if (cc1.getBits() == null || cc2.getBits() == null) {
            return true;
        }
        return cc1.getBits().intersects(cc2.getBits());
    }

    public static TAbstractCharClass getPredefinedClass(String name, boolean negative) {
        return ((LazyCharClass)charClasses.getObject(name)).getValue(negative);
    }

    static final class PredefinedCharacterClasses {
        static LazyCharClass space = new LazySpace();
        static LazyCharClass digit = new LazyDigit();
        static final Object[][] contents = new Object[][]{{"Lower", new LazyLower()}, {"Upper", new LazyUpper()}, {"ASCII", new LazyASCII()}, {"Alpha", new LazyAlpha()}, {"Digit", digit}, {"Alnum", new LazyAlnum()}, {"Punct", new LazyPunct()}, {"Graph", new LazyGraph()}, {"Print", new LazyPrint()}, {"Blank", new LazyBlank()}, {"Cntrl", new LazyCntrl()}, {"XDigit", new LazyXDigit()}, {"javaLowerCase", new LazyJavaLowerCase()}, {"javaUpperCase", new LazyJavaUpperCase()}, {"javaWhitespace", new LazyJavaWhitespace()}, {"javaMirrored", new LazyJavaMirrored()}, {"javaDefined", new LazyJavaDefined()}, {"javaDigit", new LazyJavaDigit()}, {"javaIdentifierIgnorable", new LazyJavaIdentifierIgnorable()}, {"javaISOControl", new LazyJavaISOControl()}, {"javaJavaIdentifierPart", new LazyJavaJavaIdentifierPart()}, {"javaJavaIdentifierStart", new LazyJavaJavaIdentifierStart()}, {"javaLetter", new LazyJavaLetter()}, {"javaLetterOrDigit", new LazyJavaLetterOrDigit()}, {"javaSpaceChar", new LazyJavaSpaceChar()}, {"javaTitleCase", new LazyJavaTitleCase()}, {"javaUnicodeIdentifierPart", new LazyJavaUnicodeIdentifierPart()}, {"javaUnicodeIdentifierStart", new LazyJavaUnicodeIdentifierStart()}, {"Space", space}, {"w", new LazyWord()}, {"W", new LazyNonWord()}, {"s", space}, {"S", new LazyNonSpace()}, {"d", digit}, {"D", new LazyNonDigit()}, {"BasicLatin", new LazyRange(0, 127)}, {"Latin-1Supplement", new LazyRange(128, 255)}, {"LatinExtended-A", new LazyRange(256, 383)}, {"LatinExtended-B", new LazyRange(384, 591)}, {"IPAExtensions", new LazyRange(592, 687)}, {"SpacingModifierLetters", new LazyRange(688, 767)}, {"CombiningDiacriticalMarks", new LazyRange(768, 879)}, {"Greek", new LazyRange(880, 1023)}, {"Cyrillic", new LazyRange(1024, 1279)}, {"CyrillicSupplement", new LazyRange(1280, 1327)}, {"Armenian", new LazyRange(1328, 1423)}, {"Hebrew", new LazyRange(1424, 1535)}, {"Arabic", new LazyRange(1536, 1791)}, {"Syriac", new LazyRange(1792, 1871)}, {"ArabicSupplement", new LazyRange(1872, 1919)}, {"Thaana", new LazyRange(1920, 1983)}, {"Devanagari", new LazyRange(2304, 2431)}, {"Bengali", new LazyRange(2432, 2559)}, {"Gurmukhi", new LazyRange(2560, 2687)}, {"Gujarati", new LazyRange(2688, 2815)}, {"Oriya", new LazyRange(2816, 2943)}, {"Tamil", new LazyRange(2944, 3071)}, {"Telugu", new LazyRange(3072, 3199)}, {"Kannada", new LazyRange(3200, 3327)}, {"Malayalam", new LazyRange(3328, 3455)}, {"Sinhala", new LazyRange(3456, 3583)}, {"Thai", new LazyRange(3584, 3711)}, {"Lao", new LazyRange(3712, 3839)}, {"Tibetan", new LazyRange(3840, 4095)}, {"Myanmar", new LazyRange(4096, 4255)}, {"Georgian", new LazyRange(4256, 4351)}, {"HangulJamo", new LazyRange(4352, 4607)}, {"Ethiopic", new LazyRange(4608, 4991)}, {"EthiopicSupplement", new LazyRange(4992, 5023)}, {"Cherokee", new LazyRange(5024, 5119)}, {"UnifiedCanadianAboriginalSyllabics", new LazyRange(5120, 5759)}, {"Ogham", new LazyRange(5760, 5791)}, {"Runic", new LazyRange(5792, 5887)}, {"Tagalog", new LazyRange(5888, 5919)}, {"Hanunoo", new LazyRange(5920, 5951)}, {"Buhid", new LazyRange(5952, 5983)}, {"Tagbanwa", new LazyRange(5984, 6015)}, {"Khmer", new LazyRange(6016, 6143)}, {"Mongolian", new LazyRange(6144, 6319)}, {"Limbu", new LazyRange(6400, 6479)}, {"TaiLe", new LazyRange(6480, 6527)}, {"NewTaiLue", new LazyRange(6528, 6623)}, {"KhmerSymbols", new LazyRange(6624, 6655)}, {"Buginese", new LazyRange(6656, 6687)}, {"PhoneticExtensions", new LazyRange(7424, 7551)}, {"PhoneticExtensionsSupplement", new LazyRange(7552, 7615)}, {"CombiningDiacriticalMarksSupplement", new LazyRange(7616, 7679)}, {"LatinExtendedAdditional", new LazyRange(7680, 7935)}, {"GreekExtended", new LazyRange(7936, 8191)}, {"GeneralPunctuation", new LazyRange(8192, 8303)}, {"SuperscriptsandSubscripts", new LazyRange(8304, 8351)}, {"CurrencySymbols", new LazyRange(8352, 8399)}, {"CombiningMarksforSymbols", new LazyRange(8400, 8447)}, {"LetterlikeSymbols", new LazyRange(8448, 8527)}, {"NumberForms", new LazyRange(8528, 8591)}, {"Arrows", new LazyRange(8592, 8703)}, {"MathematicalOperators", new LazyRange(8704, 8959)}, {"MiscellaneousTechnical", new LazyRange(8960, 9215)}, {"ControlPictures", new LazyRange(9216, 9279)}, {"OpticalCharacterRecognition", new LazyRange(9280, 9311)}, {"EnclosedAlphanumerics", new LazyRange(9312, 9471)}, {"BoxDrawing", new LazyRange(9472, 9599)}, {"BlockElements", new LazyRange(9600, 9631)}, {"GeometricShapes", new LazyRange(9632, 9727)}, {"MiscellaneousSymbols", new LazyRange(9728, 9983)}, {"Dingbats", new LazyRange(9984, 10175)}, {"MiscellaneousMathematicalSymbols-A", new LazyRange(10176, 10223)}, {"SupplementalArrows-A", new LazyRange(10224, 10239)}, {"BraillePatterns", new LazyRange(10240, 10495)}, {"SupplementalArrows-B", new LazyRange(10496, 10623)}, {"MiscellaneousMathematicalSymbols-B", new LazyRange(10624, 10751)}, {"SupplementalMathematicalOperators", new LazyRange(10752, 11007)}, {"MiscellaneousSymbolsandArrows", new LazyRange(11008, 11263)}, {"Glagolitic", new LazyRange(11264, 11359)}, {"Coptic", new LazyRange(11392, 11519)}, {"GeorgianSupplement", new LazyRange(11520, 11567)}, {"Tifinagh", new LazyRange(11568, 11647)}, {"EthiopicExtended", new LazyRange(11648, 11743)}, {"SupplementalPunctuation", new LazyRange(11776, 11903)}, {"CJKRadicalsSupplement", new LazyRange(11904, 12031)}, {"KangxiRadicals", new LazyRange(12032, 12255)}, {"IdeographicDescriptionCharacters", new LazyRange(12272, 12287)}, {"CJKSymbolsandPunctuation", new LazyRange(12288, 12351)}, {"Hiragana", new LazyRange(12352, 12447)}, {"Katakana", new LazyRange(12448, 12543)}, {"Bopomofo", new LazyRange(12544, 12591)}, {"HangulCompatibilityJamo", new LazyRange(12592, 12687)}, {"Kanbun", new LazyRange(12688, 12703)}, {"BopomofoExtended", new LazyRange(12704, 12735)}, {"CJKStrokes", new LazyRange(12736, 12783)}, {"KatakanaPhoneticExtensions", new LazyRange(12784, 12799)}, {"EnclosedCJKLettersandMonths", new LazyRange(12800, 13055)}, {"CJKCompatibility", new LazyRange(13056, 13311)}, {"CJKUnifiedIdeographsExtensionA", new LazyRange(13312, 19893)}, {"YijingHexagramSymbols", new LazyRange(19904, 19967)}, {"CJKUnifiedIdeographs", new LazyRange(19968, 40959)}, {"YiSyllables", new LazyRange(40960, 42127)}, {"YiRadicals", new LazyRange(42128, 42191)}, {"ModifierToneLetters", new LazyRange(42752, 42783)}, {"SylotiNagri", new LazyRange(43008, 43055)}, {"HangulSyllables", new LazyRange(44032, 55203)}, {"HighSurrogates", new LazyRange(55296, 56191)}, {"HighPrivateUseSurrogates", new LazyRange(56192, 56319)}, {"LowSurrogates", new LazyRange(56320, 57343)}, {"PrivateUseArea", new LazyRange(57344, 63743)}, {"CJKCompatibilityIdeographs", new LazyRange(63744, 64255)}, {"AlphabeticPresentationForms", new LazyRange(64256, 64335)}, {"ArabicPresentationForms-A", new LazyRange(64336, 65023)}, {"VariationSelectors", new LazyRange(65024, 65039)}, {"VerticalForms", new LazyRange(65040, 65055)}, {"CombiningHalfMarks", new LazyRange(65056, 65071)}, {"CJKCompatibilityForms", new LazyRange(65072, 65103)}, {"SmallFormVariants", new LazyRange(65104, 65135)}, {"ArabicPresentationForms-B", new LazyRange(65136, 65279)}, {"HalfwidthandFullwidthForms", new LazyRange(65280, 65519)}, {"all", new LazyRange(0, 0x10FFFF)}, {"Specials", new LazySpecialsBlock()}, {"Cn", new LazyCategory(0, true)}, {"IsL", new LazyCategoryScope(62, true)}, {"Lu", new LazyCategory(1, true)}, {"Ll", new LazyCategory(2, true)}, {"Lt", new LazyCategory(3, false)}, {"Lm", new LazyCategory(4, false)}, {"Lo", new LazyCategory(5, true)}, {"IsM", new LazyCategoryScope(448, true)}, {"Mn", new LazyCategory(6, true)}, {"Me", new LazyCategory(7, false)}, {"Mc", new LazyCategory(8, true)}, {"N", new LazyCategoryScope(3584, true)}, {"Nd", new LazyCategory(9, true)}, {"Nl", new LazyCategory(10, true)}, {"No", new LazyCategory(11, true)}, {"IsZ", new LazyCategoryScope(28672, false)}, {"Zs", new LazyCategory(12, false)}, {"Zl", new LazyCategory(13, false)}, {"Zp", new LazyCategory(14, false)}, {"IsC", new LazyCategoryScope(983040, true, true)}, {"Cc", new LazyCategory(15, false)}, {"Cf", new LazyCategory(16, true)}, {"Co", new LazyCategory(18, true)}, {"Cs", new LazyCategory(19, false, true)}, {"IsP", new LazyCategoryScope(1643118592, true)}, {"Pd", new LazyCategory(20, false)}, {"Ps", new LazyCategory(21, false)}, {"Pe", new LazyCategory(22, false)}, {"Pc", new LazyCategory(23, false)}, {"Po", new LazyCategory(24, true)}, {"IsS", new LazyCategoryScope(0x7E000000, true)}, {"Sm", new LazyCategory(25, true)}, {"Sc", new LazyCategory(26, false)}, {"Sk", new LazyCategory(27, false)}, {"So", new LazyCategory(28, true)}, {"Pi", new LazyCategory(29, false)}, {"Pf", new LazyCategory(30, false)}};

        PredefinedCharacterClasses() {
        }

        public Object getObject(String name) {
            for (int i = 0; i < contents.length; ++i) {
                Object[] row = contents[i];
                if (!name.equals(row[0])) continue;
                return row[1];
            }
            throw new MissingResourceException("", "", name);
        }
    }

    static class LazyJavaUnicodeIdentifierStart
    extends LazyCharClass {
        LazyJavaUnicodeIdentifierStart() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isUnicodeIdentifierStart(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaUnicodeIdentifierPart
    extends LazyCharClass {
        LazyJavaUnicodeIdentifierPart() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isUnicodeIdentifierPart(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaTitleCase
    extends LazyCharClass {
        LazyJavaTitleCase() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isTitleCase(ch);
                }
            };
        }
    }

    static class LazyJavaSpaceChar
    extends LazyCharClass {
        LazyJavaSpaceChar() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isSpaceChar(ch);
                }
            };
        }
    }

    static class LazyJavaLetterOrDigit
    extends LazyCharClass {
        LazyJavaLetterOrDigit() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isLetterOrDigit(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaLetter
    extends LazyCharClass {
        LazyJavaLetter() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isLetter(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaJavaIdentifierStart
    extends LazyCharClass {
        LazyJavaJavaIdentifierStart() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isJavaIdentifierStart(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaJavaIdentifierPart
    extends LazyCharClass {
        LazyJavaJavaIdentifierPart() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isJavaIdentifierPart(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaISOControl
    extends LazyCharClass {
        LazyJavaISOControl() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isISOControl(ch);
                }
            };
        }
    }

    static class LazyJavaIdentifierIgnorable
    extends LazyCharClass {
        LazyJavaIdentifierIgnorable() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isIdentifierIgnorable(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaDigit
    extends LazyCharClass {
        LazyJavaDigit() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isDigit(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaDefined
    extends LazyCharClass {
        LazyJavaDefined() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isDefined(ch);
                }
            };
            chCl.lowHighSurrogates.set(0, 2048);
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaMirrored
    extends LazyCharClass {
        LazyJavaMirrored() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return false;
                }
            };
        }
    }

    static class LazyJavaWhitespace
    extends LazyCharClass {
        LazyJavaWhitespace() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isWhitespace(ch);
                }
            };
        }
    }

    static class LazyJavaUpperCase
    extends LazyCharClass {
        LazyJavaUpperCase() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isUpperCase(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyJavaLowerCase
    extends LazyCharClass {
        LazyJavaLowerCase() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = new TAbstractCharClass(){

                @Override
                public boolean contains(int ch) {
                    return Character.isLowerCase(ch);
                }
            };
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyCategory
    extends LazyCharClass {
        int category;
        boolean mayContainSupplCodepoints;
        boolean containsAllSurrogates;

        public LazyCategory(int cat, boolean mayContainSupplCodepoints) {
            this.mayContainSupplCodepoints = mayContainSupplCodepoints;
            this.category = cat;
        }

        public LazyCategory(int cat, boolean mayContainSupplCodepoints, boolean containsAllSurrogates) {
            this.containsAllSurrogates = containsAllSurrogates;
            this.mayContainSupplCodepoints = mayContainSupplCodepoints;
            this.category = cat;
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TUnicodeCategory chCl = new TUnicodeCategory(this.category);
            if (this.containsAllSurrogates) {
                chCl.lowHighSurrogates.set(0, 2048);
            }
            chCl.mayContainSupplCodepoints = this.mayContainSupplCodepoints;
            return chCl;
        }
    }

    static class LazyCategoryScope
    extends LazyCharClass {
        int category;
        boolean mayContainSupplCodepoints;
        boolean containsAllSurrogates;

        public LazyCategoryScope(int cat, boolean mayContainSupplCodepoints) {
            this.mayContainSupplCodepoints = mayContainSupplCodepoints;
            this.category = cat;
        }

        public LazyCategoryScope(int cat, boolean mayContainSupplCodepoints, boolean containsAllSurrogates) {
            this.containsAllSurrogates = containsAllSurrogates;
            this.mayContainSupplCodepoints = mayContainSupplCodepoints;
            this.category = cat;
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TUnicodeCategoryScope chCl = new TUnicodeCategoryScope(this.category);
            if (this.containsAllSurrogates) {
                chCl.lowHighSurrogates.set(0, 2048);
            }
            chCl.mayContainSupplCodepoints = this.mayContainSupplCodepoints;
            return chCl;
        }
    }

    static class LazySpecialsBlock
    extends LazyCharClass {
        LazySpecialsBlock() {
        }

        @Override
        public TAbstractCharClass computeValue() {
            return new TCharClass().add(65279, 65279).add(65520, 65533);
        }
    }

    static class LazyRange
    extends LazyCharClass {
        int start;
        int end;

        public LazyRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public TAbstractCharClass computeValue() {
            TCharClass chCl = new TCharClass().add(this.start, this.end);
            return chCl;
        }
    }

    static class LazyXDigit
    extends LazyCharClass {
        LazyXDigit() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(48, 57).add(97, 102).add(65, 70);
        }
    }

    static class LazyCntrl
    extends LazyCharClass {
        LazyCntrl() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(0, 31).add(127);
        }
    }

    static class LazyBlank
    extends LazyCharClass {
        LazyBlank() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(32).add(9);
        }
    }

    static class LazyPrint
    extends LazyGraph {
        LazyPrint() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return ((TCharClass)super.computeValue()).add(32);
        }
    }

    static class LazyGraph
    extends LazyAlnum {
        LazyGraph() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return ((TCharClass)super.computeValue()).add(33, 64).add(91, 96).add(123, 126);
        }
    }

    static class LazyPunct
    extends LazyCharClass {
        LazyPunct() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(33, 64).add(91, 96).add(123, 126);
        }
    }

    static class LazyAlnum
    extends LazyAlpha {
        LazyAlnum() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return ((TCharClass)super.computeValue()).add(48, 57);
        }
    }

    static class LazyAlpha
    extends LazyCharClass {
        LazyAlpha() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(97, 122).add(65, 90);
        }
    }

    static class LazyASCII
    extends LazyCharClass {
        LazyASCII() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(0, 127);
        }
    }

    static class LazyUpper
    extends LazyCharClass {
        LazyUpper() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(65, 90);
        }
    }

    static class LazyLower
    extends LazyCharClass {
        LazyLower() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(97, 122);
        }
    }

    static class LazyNonWord
    extends LazyWord {
        LazyNonWord() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = super.computeValue().setNegative(true);
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyWord
    extends LazyCharClass {
        LazyWord() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(97, 122).add(65, 90).add(48, 57).add(95);
        }
    }

    static class LazyNonSpace
    extends LazySpace {
        LazyNonSpace() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = super.computeValue().setNegative(true);
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazySpace
    extends LazyCharClass {
        LazySpace() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(9, 13).add(32);
        }
    }

    static class LazyNonDigit
    extends LazyDigit {
        LazyNonDigit() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            TAbstractCharClass chCl = super.computeValue().setNegative(true);
            chCl.mayContainSupplCodepoints = true;
            return chCl;
        }
    }

    static class LazyDigit
    extends LazyCharClass {
        LazyDigit() {
        }

        @Override
        protected TAbstractCharClass computeValue() {
            return new TCharClass().add(48, 57);
        }
    }

    static abstract class LazyCharClass {
        TAbstractCharClass posValue;
        TAbstractCharClass negValue;

        LazyCharClass() {
        }

        public TAbstractCharClass getValue(boolean negative) {
            if (!negative && this.posValue == null) {
                this.posValue = this.computeValue();
            } else if (negative && this.negValue == null) {
                this.negValue = this.computeValue().setNegative(true);
            }
            if (!negative) {
                return this.posValue;
            }
            return this.negValue;
        }

        protected abstract TAbstractCharClass computeValue();
    }
}

