/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.apache.commons.io.IOUtils;
import org.teavm.classlib.ResourceSupplier;
import org.teavm.codegen.SourceWriter;
import org.teavm.javascript.Renderer;
import org.teavm.javascript.spi.Injector;
import org.teavm.javascript.spi.InjectorContext;
import org.teavm.model.MethodReference;

public class ClassLoaderNativeGenerator
implements Injector {
    public void generate(InjectorContext context, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "supplyResources": {
                this.generateSupplyResources(context);
            }
        }
    }

    private void generateSupplyResources(InjectorContext context) throws IOException {
        SourceWriter writer = context.getWriter();
        writer.append("{").indent();
        ClassLoader classLoader = context.getClassLoader();
        HashSet<String> resourceSet = new HashSet<String>();
        for (ResourceSupplier supplier : ServiceLoader.load(ResourceSupplier.class, classLoader)) {
            String[] resources = supplier.supplyResources(classLoader, context.getClassSource());
            if (resources == null) continue;
            resourceSet.addAll(Arrays.asList(resources));
        }
        boolean first = true;
        for (String resource : resourceSet) {
            InputStream input = classLoader.getResourceAsStream(resource);
            Throwable throwable = null;
            try {
                if (input == null) continue;
                if (!first) {
                    writer.append(',');
                }
                first = false;
                writer.newLine();
                String data = Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)input));
                writer.append("\"").append(Renderer.escapeString((String)resource)).append("\"");
                writer.ws().append(':').ws();
                writer.append("\"").append(data).append("\"");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                input.close();
            }
        }
        if (!first) {
            writer.newLine();
        }
        writer.outdent().append('}');
    }
}

