/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import java.util.Arrays;
import org.teavm.classlib.java.util.regex.TMatchResult;
import org.teavm.classlib.java.util.regex.TMatcher;

class TMatchResultImpl
implements TMatchResult {
    private int[] groupBounds = null;
    private int[] consumers = null;
    private int[] compQuantCounters = null;
    private CharSequence string = null;
    private int groupCount = 0;
    private boolean valid = false;
    private int leftBound;
    private int rightBound;
    int startIndex;
    private boolean transparentBounds = false;
    private boolean anchoringBounds = false;
    boolean hitEnd = false;
    boolean requireEnd = false;
    int previousMatch = -1;
    private int mode;

    TMatchResultImpl(CharSequence string, int leftBound, int rightBound, int groupCount, int compQuantCount, int consumersCount) {
        this.groupCount = ++groupCount;
        this.groupBounds = new int[groupCount * 2];
        this.consumers = new int[consumersCount];
        Arrays.fill(this.consumers, -1);
        if (compQuantCount > 0) {
            this.compQuantCounters = new int[compQuantCount];
        }
        Arrays.fill(this.groupBounds, -1);
        this.reset(string, leftBound, rightBound);
    }

    TMatchResult cloneImpl() {
        TMatchResultImpl res = new TMatchResultImpl(this.string, this.leftBound, this.rightBound, this.groupCount - 1, 0, 0);
        res.valid = this.valid;
        if (this.valid) {
            System.arraycopy(this.groupBounds, 0, res.groupBounds, 0, this.groupBounds.length);
        }
        return res;
    }

    public void setConsumed(int counter, int value) {
        this.consumers[counter] = value;
    }

    public int getConsumed(int counter) {
        return this.consumers[counter];
    }

    @Override
    public int end() {
        return this.end(0);
    }

    @Override
    public int end(int group) {
        this.checkGroup(group);
        return this.groupBounds[group * 2 + 1];
    }

    void setStart(int group, int offset) {
        this.groupBounds[group * 2] = offset;
    }

    void setEnd(int group, int offset) {
        this.groupBounds[group * 2 + 1] = offset;
    }

    int getStart(int group) {
        return this.groupBounds[group * 2];
    }

    int getEnd(int group) {
        return this.groupBounds[group * 2 + 1];
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int group) {
        if (this.start(group) < 0) {
            return null;
        }
        return this.string.subSequence(this.start(group), this.end(group)).toString();
    }

    String getGroupNoCheck(int group) {
        int st = this.getStart(group);
        int end = this.getEnd(group);
        if ((end | st | end - st) < 0 || end > this.string.length()) {
            return null;
        }
        return this.string.subSequence(st, end).toString();
    }

    @Override
    public int groupCount() {
        return this.groupCount - 1;
    }

    @Override
    public int start() {
        return this.start(0);
    }

    @Override
    public int start(int group) {
        this.checkGroup(group);
        return this.groupBounds[group * 2];
    }

    public void finalizeMatch() {
        if (this.groupBounds[0] == -1) {
            this.groupBounds[0] = this.startIndex;
            this.groupBounds[1] = this.startIndex;
        }
        this.previousMatch = this.end();
    }

    public int getEnterCounter(int setCounter) {
        return this.compQuantCounters[setCounter];
    }

    public void setEnterCounter(int setCounter, int value) {
        this.compQuantCounters[setCounter] = value;
    }

    private void checkGroup(int group) {
        if (!this.valid) {
            throw new IllegalStateException();
        }
        if (group < 0 || group >= this.groupCount) {
            throw new IndexOutOfBoundsException(String.valueOf(group));
        }
    }

    void updateGroup(int index, int srtOffset, int endOffset) {
        this.checkGroup(index);
        this.groupBounds[index * 2] = srtOffset;
        this.groupBounds[index * 2 + 1] = endOffset;
    }

    protected void setValid() {
        this.valid = true;
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected void reset(CharSequence newSequence, int leftBound, int rightBound) {
        this.valid = false;
        this.mode = TMatcher.MODE_MATCH;
        Arrays.fill(this.groupBounds, -1);
        Arrays.fill(this.consumers, -1);
        if (newSequence != null) {
            this.string = newSequence;
        }
        if (leftBound >= 0) {
            this.setBounds(leftBound, rightBound);
        }
        this.startIndex = this.leftBound;
    }

    protected void reset() {
        this.reset(null, -1, -1);
    }

    private void setBounds(int leftBound, int rightBound) {
        this.leftBound = leftBound;
        this.rightBound = rightBound;
    }

    protected void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        this.previousMatch = this.previousMatch >= 0 ? this.previousMatch : startIndex;
    }

    public int getLeftBound() {
        return this.leftBound;
    }

    public int getRightBound() {
        return this.rightBound;
    }

    protected void setMode(int mode) {
        this.mode = mode;
    }

    protected int mode() {
        return this.mode;
    }

    protected void useAnchoringBounds(boolean value) {
        this.anchoringBounds = value;
    }

    protected boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    protected void useTransparentBounds(boolean value) {
        this.transparentBounds = value;
    }

    protected boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    int getPreviousMatchEnd() {
        return this.previousMatch;
    }
}

