/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.net;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TException;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.TStringBuilder;
import org.teavm.classlib.java.net.TURIEncoderDecoder;
import org.teavm.classlib.java.net.TURISyntaxException;

public final class TURI
implements TComparable<TURI>,
TSerializable {
    static final TString unreserved = TString.wrap("_-!.~'()*");
    static final TString punct = TString.wrap(",;:$&+=");
    static final TString reserved = TString.wrap(punct.toString() + "?/[]@");
    static final TString someLegal = TString.wrap(unreserved.toString() + punct.toString());
    static final TString queryLegal = TString.wrap(unreserved.toString() + reserved.toString() + "\\\"");
    static final TString allLegal = TString.wrap(unreserved.toString() + reserved.toString());
    private TString string;
    private transient TString scheme;
    private transient TString schemespecificpart;
    private transient TString authority;
    private transient TString userinfo;
    private transient TString host;
    private transient int port = -1;
    private transient TString path;
    private transient TString query;
    private transient TString fragment;
    private transient boolean opaque;
    private transient boolean absolute;
    private transient boolean serverAuthority;
    private transient int hash = -1;

    private TURI() {
    }

    public TURI(TString uri) throws TURISyntaxException {
        new Helper().parseURI(uri, false);
    }

    public TURI(TString scheme, TString ssp, TString frag) throws TURISyntaxException {
        TStringBuilder uri = new TStringBuilder();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (ssp != null) {
            uri.append(this.quoteComponent(ssp, allLegal));
        }
        if (frag != null) {
            uri.append('#');
            uri.append(this.quoteComponent(frag, allLegal));
        }
        new Helper().parseURI(TString.wrap(uri.toString()), false);
    }

    public TURI(TString scheme, TString userinfo, TString host, int port, TString path, TString query, TString fragment) throws TURISyntaxException {
        if (scheme == null && userinfo == null && host == null && path == null && query == null && fragment == null) {
            this.path = TString.wrap("");
            return;
        }
        if (scheme != null && path != null && path.length() > 0 && path.charAt(0) != '/') {
            throw new TURISyntaxException(path, TString.wrap(""));
        }
        TStringBuilder uri = new TStringBuilder();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (userinfo != null || host != null || port != -1) {
            uri.append(TString.wrap("//"));
        }
        if (userinfo != null) {
            uri.append(this.quoteComponent(userinfo, someLegal));
            uri.append('@');
        }
        if (host != null) {
            if (host.indexOf(58) != -1 && host.indexOf(93) == -1 && host.indexOf(91) == -1) {
                host = TString.wrap("[" + host.toString() + "]");
            }
            uri.append(host);
        }
        if (port != -1) {
            uri.append(':');
            uri.append(port);
        }
        if (path != null) {
            uri.append(this.quoteComponent(path, TString.wrap("/@" + someLegal.toString())));
        }
        if (query != null) {
            uri.append('?');
            uri.append(this.quoteComponent(query, allLegal));
        }
        if (fragment != null) {
            uri.append('#');
            uri.append(this.quoteComponent(fragment, allLegal));
        }
        new Helper().parseURI(TString.wrap(uri.toString()), true);
    }

    public TURI(TString scheme, TString host, TString path, TString fragment) throws TURISyntaxException {
        this(scheme, null, host, -1, path, null, fragment);
    }

    public TURI(TString scheme, TString authority, TString path, TString query, TString fragment) throws TURISyntaxException {
        if (scheme != null && path != null && path.length() > 0 && path.charAt(0) != '/') {
            throw new TURISyntaxException(path, TString.wrap(""));
        }
        TStringBuilder uri = new TStringBuilder();
        if (scheme != null) {
            uri.append(scheme);
            uri.append(':');
        }
        if (authority != null) {
            uri.append(TString.wrap("//"));
            uri.append(this.quoteComponent(authority, TString.wrap("@[]" + someLegal.toString())));
        }
        if (path != null) {
            uri.append(this.quoteComponent(path, TString.wrap("/@" + someLegal.toString())));
        }
        if (query != null) {
            uri.append('?');
            uri.append(this.quoteComponent(query, allLegal));
        }
        if (fragment != null) {
            uri.append('#');
            uri.append(this.quoteComponent(fragment, allLegal));
        }
        new Helper().parseURI(TString.wrap(uri.toString()), false);
    }

    private TString quoteComponent(TString component, TString legalset) {
        return TURIEncoderDecoder.quoteIllegal(component, legalset);
    }

    @Override
    public int compareTo(TURI uri) {
        int ret = 0;
        if (this.scheme == null && uri.scheme != null) {
            return -1;
        }
        if (this.scheme != null && uri.scheme == null) {
            return 1;
        }
        if (this.scheme != null && uri.scheme != null && (ret = this.scheme.compareTo(uri.scheme)) != 0) {
            return ret;
        }
        if (!this.opaque && uri.opaque) {
            return -1;
        }
        if (this.opaque && !uri.opaque) {
            return 1;
        }
        if (this.opaque && uri.opaque) {
            ret = this.schemespecificpart.compareTo(uri.schemespecificpart);
            if (ret != 0) {
                return ret;
            }
        } else {
            if (this.authority != null && uri.authority == null) {
                return 1;
            }
            if (this.authority == null && uri.authority != null) {
                return -1;
            }
            if (this.authority != null && uri.authority != null) {
                if (this.host != null && uri.host != null) {
                    if (this.userinfo != null && uri.userinfo == null) {
                        return 1;
                    }
                    if (this.userinfo == null && uri.userinfo != null) {
                        return -1;
                    }
                    if (this.userinfo != null && uri.userinfo != null && (ret = this.userinfo.compareTo(uri.userinfo)) != 0) {
                        return ret;
                    }
                    ret = this.host.compareTo(uri.host);
                    if (ret != 0) {
                        return ret;
                    }
                    if (this.port != uri.port) {
                        return this.port - uri.port;
                    }
                } else {
                    ret = this.authority.compareTo(uri.authority);
                    if (ret != 0) {
                        return ret;
                    }
                }
            }
            if ((ret = this.path.compareTo(uri.path)) != 0) {
                return ret;
            }
            if (this.query != null && uri.query == null) {
                return 1;
            }
            if (this.query == null && uri.query != null) {
                return -1;
            }
            if (this.query != null && uri.query != null && (ret = this.query.compareTo(uri.query)) != 0) {
                return ret;
            }
        }
        if (this.fragment != null && uri.fragment == null) {
            return 1;
        }
        if (this.fragment == null && uri.fragment != null) {
            return -1;
        }
        if (this.fragment != null && uri.fragment != null && (ret = this.fragment.compareTo(uri.fragment)) != 0) {
            return ret;
        }
        return 0;
    }

    public static TURI create(TString uri) {
        TURI result = null;
        try {
            result = new TURI(uri);
        }
        catch (TURISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return result;
    }

    private TURI duplicate() {
        TURI clone = new TURI();
        clone.absolute = this.absolute;
        clone.authority = this.authority;
        clone.fragment = this.fragment;
        clone.host = this.host;
        clone.opaque = this.opaque;
        clone.path = this.path;
        clone.port = this.port;
        clone.query = this.query;
        clone.scheme = this.scheme;
        clone.schemespecificpart = this.schemespecificpart;
        clone.userinfo = this.userinfo;
        clone.serverAuthority = this.serverAuthority;
        return clone;
    }

    private TString convertHexToLowerCase(TString s) {
        TStringBuilder result = new TStringBuilder();
        if (s.indexOf(37) == -1) {
            return s;
        }
        int index = 0;
        int previndex = 0;
        while ((index = s.indexOf(37, previndex)) != -1) {
            result.append(s.substring(previndex, index + 1));
            result.append(s.substring(index + 1, index + 3).toLowerCase());
            previndex = index += 3;
        }
        return TString.wrap(result.toString());
    }

    private boolean equalsHexCaseInsensitive(TString first, TString second) {
        if (first.indexOf(37) != second.indexOf(37)) {
            return first.equals(second);
        }
        int index = 0;
        int previndex = 0;
        while ((index = first.indexOf(37, previndex)) != -1 && second.indexOf(37, previndex) == index) {
            boolean match = first.substring(previndex, index).equals(second.substring(previndex, index));
            if (!match) {
                return false;
            }
            match = first.substring(index + 1, index + 3).equals(second.substring(index + 1, index + 3));
            if (!match) {
                return false;
            }
            previndex = index += 3;
        }
        return first.substring(previndex).equals(second.substring(previndex));
    }

    public boolean equals(Object o) {
        if (!(o instanceof TURI)) {
            return false;
        }
        TURI uri = (TURI)o;
        if (uri.fragment == null && this.fragment != null || uri.fragment != null && this.fragment == null) {
            return false;
        }
        if (uri.fragment != null && this.fragment != null && !this.equalsHexCaseInsensitive(uri.fragment, this.fragment)) {
            return false;
        }
        if (uri.scheme == null && this.scheme != null || uri.scheme != null && this.scheme == null) {
            return false;
        }
        if (uri.scheme != null && this.scheme != null && !uri.scheme.equals(this.scheme)) {
            return false;
        }
        if (uri.opaque && this.opaque) {
            return this.equalsHexCaseInsensitive(uri.schemespecificpart, this.schemespecificpart);
        }
        if (!uri.opaque && !this.opaque) {
            if (!this.equalsHexCaseInsensitive(this.path, uri.path)) {
                return false;
            }
            if (uri.query != null && this.query == null || uri.query == null && this.query != null) {
                return false;
            }
            if (uri.query != null && this.query != null && !this.equalsHexCaseInsensitive(uri.query, this.query)) {
                return false;
            }
            if (uri.authority != null && this.authority == null || uri.authority == null && this.authority != null) {
                return false;
            }
            if (uri.authority != null && this.authority != null) {
                if (uri.host != null && this.host == null || uri.host == null && this.host != null) {
                    return false;
                }
                if (uri.host == null && this.host == null) {
                    return this.equalsHexCaseInsensitive(uri.authority, this.authority);
                }
                if (!this.host.equals(uri.host)) {
                    return false;
                }
                if (this.port != uri.port) {
                    return false;
                }
                if (uri.userinfo != null && this.userinfo == null || uri.userinfo == null && this.userinfo != null) {
                    return false;
                }
                if (uri.userinfo != null && this.userinfo != null) {
                    return this.equalsHexCaseInsensitive(this.userinfo, uri.userinfo);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public TString getAuthority() {
        return this.decode(this.authority);
    }

    public TString getFragment() {
        return this.decode(this.fragment);
    }

    public TString getHost() {
        return this.host;
    }

    public TString getPath() {
        return this.decode(this.path);
    }

    public int getPort() {
        return this.port;
    }

    public TString getQuery() {
        return this.decode(this.query);
    }

    public TString getRawAuthority() {
        return this.authority;
    }

    public TString getRawFragment() {
        return this.fragment;
    }

    public TString getRawPath() {
        return this.path;
    }

    public TString getRawQuery() {
        return this.query;
    }

    public TString getRawSchemeSpecificPart() {
        return this.schemespecificpart;
    }

    public TString getRawUserInfo() {
        return this.userinfo;
    }

    public TString getScheme() {
        return this.scheme;
    }

    public TString getSchemeSpecificPart() {
        return this.decode(this.schemespecificpart);
    }

    public TString getUserInfo() {
        return this.decode(this.userinfo);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.getHashString().hashCode();
        }
        return this.hash;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    private TString normalize(TString path) {
        int index = -1;
        int pathlen = path.length();
        int size = 0;
        if (pathlen > 0 && path.charAt(0) != '/') {
            ++size;
        }
        while ((index = path.indexOf(47, index + 1)) != -1) {
            if (index + 1 >= pathlen || path.charAt(index + 1) == '/') continue;
            ++size;
        }
        TString[] seglist = new TString[size];
        boolean[] include = new boolean[size];
        int current = 0;
        int index2 = 0;
        int n = index = pathlen > 0 && path.charAt(0) == '/' ? 1 : 0;
        while ((index2 = path.indexOf(47, index + 1)) != -1) {
            seglist[current++] = path.substring(index, index2);
            index = index2 + 1;
        }
        if (current < size) {
            seglist[current] = path.substring(index);
        }
        for (int i = 0; i < size; ++i) {
            include[i] = true;
            if (seglist[i].equals("..")) {
                int remove;
                for (remove = i - 1; remove > -1 && !include[remove]; --remove) {
                }
                if (remove <= -1 || seglist[remove].equals("..")) continue;
                include[remove] = false;
                include[i] = false;
                continue;
            }
            if (!seglist[i].equals(".")) continue;
            include[i] = false;
        }
        TStringBuilder newpath = new TStringBuilder();
        if (path.startsWith(TString.wrap("/"))) {
            newpath.append('/');
        }
        for (int i = 0; i < seglist.length; ++i) {
            if (!include[i]) continue;
            newpath.append(seglist[i]);
            newpath.append('/');
        }
        if (!path.endsWith(TString.wrap("/")) && seglist.length > 0 && include[seglist.length - 1]) {
            newpath.deleteCharAt(newpath.length() - 1);
        }
        TString result = TString.wrap(newpath.toString());
        index = result.indexOf(58);
        index2 = result.indexOf(47);
        if (index != -1 && (index < index2 || index2 == -1)) {
            newpath.insert(0, TString.wrap("./"));
            result = TString.wrap(newpath.toString());
        }
        return result;
    }

    public TURI normalize() {
        if (this.opaque) {
            return this;
        }
        TString normalizedPath = this.normalize(this.path);
        if (this.path.equals(normalizedPath)) {
            return this;
        }
        TURI result = this.duplicate();
        result.path = normalizedPath;
        result.setSchemeSpecificPart();
        return result;
    }

    public TURI parseServerAuthority() throws TURISyntaxException {
        if (!this.serverAuthority) {
            new Helper().parseAuthority(true);
        }
        return this;
    }

    public TURI relativize(TURI relative) {
        TString relativePath;
        if (relative.opaque || this.opaque) {
            return relative;
        }
        if (this.scheme == null ? relative.scheme != null : !this.scheme.equals(relative.scheme)) {
            return relative;
        }
        if (this.authority == null ? relative.authority != null : !this.authority.equals(relative.authority)) {
            return relative;
        }
        TString thisPath = this.normalize(this.path);
        if (!thisPath.equals(relativePath = this.normalize(relative.path))) {
            if (!thisPath.endsWith(TString.wrap("/"))) {
                thisPath = TString.wrap(thisPath.toString()).concat(TString.valueOf('/'));
            }
            if (!relativePath.startsWith(thisPath)) {
                return relative;
            }
        }
        TURI result = new TURI();
        result.fragment = relative.fragment;
        result.query = relative.query;
        result.path = relativePath.substring(thisPath.length());
        result.setSchemeSpecificPart();
        return result;
    }

    public TURI resolve(TURI relative) {
        TURI result;
        if (relative.absolute || this.opaque) {
            return relative;
        }
        if (relative.path.equals("") && relative.scheme == null && relative.authority == null && relative.query == null && relative.fragment != null) {
            TURI result2 = this.duplicate();
            result2.fragment = relative.fragment;
            return result2;
        }
        if (relative.authority != null) {
            result = relative.duplicate();
            result.scheme = this.scheme;
            result.absolute = this.absolute;
        } else {
            result = this.duplicate();
            result.fragment = relative.fragment;
            result.query = relative.query;
            if (relative.path.startsWith(TString.wrap("/"))) {
                result.path = relative.path;
            } else {
                int endindex = this.path.lastIndexOf(47) + 1;
                result.path = this.normalize(this.path.substring(0, endindex).concat(relative.path));
            }
            result.setSchemeSpecificPart();
        }
        return result;
    }

    private void setSchemeSpecificPart() {
        TStringBuilder ssp = new TStringBuilder();
        if (this.authority != null) {
            ssp.append(TString.wrap("//")).append(this.authority);
        }
        if (this.path != null) {
            ssp.append(this.path);
        }
        if (this.query != null) {
            ssp.append(TString.wrap("?")).append(this.query);
        }
        this.schemespecificpart = TString.wrap(ssp.toString());
        this.string = null;
    }

    public TURI resolve(TString relative) {
        return this.resolve(TURI.create(relative));
    }

    private TString encodeOthers(TString s) {
        return TURIEncoderDecoder.encodeOthers(s);
    }

    private TString decode(TString s) {
        if (s == null) {
            return s;
        }
        return TURIEncoderDecoder.decode(s);
    }

    public TString toASCIIString() {
        return this.encodeOthers(TString.wrap(this.toString()));
    }

    public String toString() {
        if (this.string == null) {
            TStringBuilder result = new TStringBuilder();
            if (this.scheme != null) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.opaque) {
                result.append(this.schemespecificpart);
            } else {
                if (this.authority != null) {
                    result.append(TString.wrap("//"));
                    result.append(this.authority);
                }
                if (this.path != null) {
                    result.append(this.path);
                }
                if (this.query != null) {
                    result.append('?');
                    result.append(this.query);
                }
            }
            if (this.fragment != null) {
                result.append('#');
                result.append(this.fragment);
            }
            this.string = TString.wrap(result.toString());
        }
        return this.string.toString();
    }

    private TString getHashString() {
        TStringBuilder result = new TStringBuilder();
        if (this.scheme != null) {
            result.append(this.scheme.toLowerCase());
            result.append(':');
        }
        if (this.opaque) {
            result.append(this.schemespecificpart);
        } else {
            if (this.authority != null) {
                result.append(TString.wrap("//"));
                if (this.host == null) {
                    result.append(this.authority);
                } else {
                    if (this.userinfo != null) {
                        result.append(this.userinfo).append(TString.wrap("@"));
                    }
                    result.append(this.host.toLowerCase());
                    if (this.port != -1) {
                        result.append(':').append(this.port);
                    }
                }
            }
            if (this.path != null) {
                result.append(this.path);
            }
            if (this.query != null) {
                result.append('?').append(this.query);
            }
        }
        if (this.fragment != null) {
            result.append('#');
            result.append(this.fragment);
        }
        return this.convertHexToLowerCase(TString.wrap(result.toString()));
    }

    private class Helper {
        private Helper() {
        }

        private void parseURI(TString uri, boolean forceServer) throws TURISyntaxException {
            TString temp = uri;
            TURI.this.string = uri;
            int index = temp.indexOf(35);
            if (index != -1) {
                TURI.this.fragment = temp.substring(index + 1);
                this.validateFragment(uri, TURI.this.fragment, index + 1);
                temp = temp.substring(0, index);
            }
            int index1 = index = temp.indexOf(58);
            int index2 = temp.indexOf(47);
            int index3 = temp.indexOf(63);
            if (!(index == -1 || index2 < index && index2 != -1 || index3 < index && index3 != -1)) {
                TURI.this.absolute = true;
                TURI.this.scheme = temp.substring(0, index);
                if (TURI.this.scheme.length() == 0) {
                    throw new TURISyntaxException(uri, TString.wrap(""));
                }
                this.validateScheme(uri, TURI.this.scheme, 0);
                TURI.this.schemespecificpart = temp.substring(index + 1);
                if (TURI.this.schemespecificpart.length() == 0) {
                    throw new TURISyntaxException(uri, TString.wrap(""));
                }
            } else {
                TURI.this.absolute = false;
                TURI.this.schemespecificpart = temp;
            }
            if (TURI.this.scheme == null || TURI.this.schemespecificpart.length() > 0 && TURI.this.schemespecificpart.charAt(0) == '/') {
                TURI.this.opaque = false;
                temp = TURI.this.schemespecificpart;
                index = temp.indexOf(63);
                if (index != -1) {
                    TURI.this.query = temp.substring(index + 1);
                    temp = temp.substring(0, index);
                    this.validateQuery(uri, TURI.this.query, index2 + 1 + index);
                }
                if (temp.startsWith(TString.wrap("//"))) {
                    index = temp.indexOf(47, 2);
                    if (index != -1) {
                        TURI.this.authority = temp.substring(2, index);
                        TURI.this.path = temp.substring(index);
                    } else {
                        TURI.this.authority = temp.substring(2);
                        if (TURI.this.authority.length() == 0 && TURI.this.query == null && TURI.this.fragment == null) {
                            throw new TURISyntaxException(uri, TString.wrap(""));
                        }
                        TURI.this.path = TString.wrap("");
                    }
                    if (TURI.this.authority.length() == 0) {
                        TURI.this.authority = null;
                    } else {
                        this.validateAuthority(uri, TURI.this.authority, index1 + 3);
                    }
                } else {
                    TURI.this.path = temp;
                }
                int pathIndex = 0;
                if (index2 > -1) {
                    pathIndex += index2;
                }
                if (index > -1) {
                    pathIndex += index;
                }
                this.validatePath(uri, TURI.this.path, pathIndex);
            } else {
                TURI.this.opaque = true;
                this.validateSsp(uri, TURI.this.schemespecificpart, index2 + 2 + index);
            }
            this.parseAuthority(forceServer);
        }

        private void validateScheme(TString uri, TString scheme, int index) throws TURISyntaxException {
            char ch = scheme.charAt(0);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                throw new TURISyntaxException(uri, TString.wrap(""), 0);
            }
            try {
                TURIEncoderDecoder.validateSimple(scheme, TString.wrap("+-."));
            }
            catch (TURISyntaxException e) {
                throw new TURISyntaxException(uri, TString.wrap(""), index + e.getIndex());
            }
        }

        private void validateSsp(TString uri, TString ssp, int index) throws TURISyntaxException {
            try {
                TURIEncoderDecoder.validate(ssp, allLegal);
            }
            catch (TURISyntaxException e) {
                throw new TURISyntaxException(uri, TString.wrap(""), index + e.getIndex());
            }
        }

        private void validateAuthority(TString uri, TString authority, int index) throws TURISyntaxException {
            try {
                TURIEncoderDecoder.validate(authority, TString.wrap("@[]" + someLegal.toString()));
            }
            catch (TURISyntaxException e) {
                throw new TURISyntaxException(uri, TString.wrap(""), index + e.getIndex());
            }
        }

        private void validatePath(TString uri, TString path, int index) throws TURISyntaxException {
            try {
                TURIEncoderDecoder.validate(path, TString.wrap("/@" + someLegal.toString()));
            }
            catch (TURISyntaxException e) {
                throw new TURISyntaxException(uri, TString.wrap(""), index + e.getIndex());
            }
        }

        private void validateQuery(TString uri, TString query, int index) throws TURISyntaxException {
            try {
                TURIEncoderDecoder.validate(query, queryLegal);
            }
            catch (TURISyntaxException e) {
                throw new TURISyntaxException(uri, TString.wrap(""), index + e.getIndex());
            }
        }

        private void validateFragment(TString uri, TString fragment, int index) throws TURISyntaxException {
            try {
                TURIEncoderDecoder.validate(fragment, allLegal);
            }
            catch (TURISyntaxException e) {
                throw new TURISyntaxException(uri, TString.wrap(""), index + e.getIndex());
            }
        }

        private void parseAuthority(boolean forceServer) throws TURISyntaxException {
            if (TURI.this.authority == null) {
                return;
            }
            TString tempUserinfo = null;
            TString tempHost = null;
            int hostindex = 0;
            int tempPort = -1;
            TString temp = TURI.this.authority;
            int index = temp.indexOf(64);
            if (index != -1) {
                tempUserinfo = temp.substring(0, index);
                this.validateUserinfo(TURI.this.authority, tempUserinfo, 0);
                temp = temp.substring(index + 1);
                hostindex = index + 1;
            }
            index = temp.lastIndexOf(58);
            int endindex = temp.indexOf(93);
            if (index != -1 && endindex < index) {
                tempHost = temp.substring(0, index);
                if (index < temp.length() - 1) {
                    try {
                        tempPort = TInteger.parseInt(temp.substring(index + 1));
                        if (tempPort < 0) {
                            if (forceServer) {
                                throw new TURISyntaxException(TURI.this.authority, TString.wrap(""), hostindex + index + 1);
                            }
                            return;
                        }
                    }
                    catch (TNumberFormatException e) {
                        if (forceServer) {
                            throw new TURISyntaxException(TURI.this.authority, TString.wrap(""), hostindex + index + 1);
                        }
                        return;
                    }
                }
            } else {
                tempHost = temp;
            }
            if (tempHost.equals("")) {
                if (forceServer) {
                    throw new TURISyntaxException(TURI.this.authority, TString.wrap(""), hostindex);
                }
                return;
            }
            if (!this.isValidHost(forceServer, tempHost)) {
                return;
            }
            TURI.this.userinfo = tempUserinfo;
            TURI.this.host = tempHost;
            TURI.this.port = tempPort;
            TURI.this.serverAuthority = true;
        }

        private void validateUserinfo(TString uri, TString userinfo, int index) throws TURISyntaxException {
            for (int i = 0; i < userinfo.length(); ++i) {
                char ch = userinfo.charAt(i);
                if (ch != ']' && ch != '[') continue;
                throw new TURISyntaxException(uri, TString.wrap(""), index + i);
            }
        }

        private boolean isValidHost(boolean forceServer, TString host) throws TURISyntaxException {
            if (host.charAt(0) == '[') {
                if (host.charAt(host.length() - 1) != ']') {
                    throw new TURISyntaxException(host, TString.wrap(""), 0);
                }
                if (!this.isValidIP6Address(host)) {
                    throw new TURISyntaxException(host, TString.wrap(""));
                }
                return true;
            }
            if (host.indexOf(91) != -1 || host.indexOf(93) != -1) {
                throw new TURISyntaxException(host, TString.wrap(""), 0);
            }
            int index = host.lastIndexOf(46);
            if (index < 0 || index == host.length() - 1 || !Character.isDigit(host.charAt(index + 1))) {
                if (this.isValidDomainName(host)) {
                    return true;
                }
                if (forceServer) {
                    throw new TURISyntaxException(host, TString.wrap(""), 0);
                }
                return false;
            }
            if (this.isValidIPv4Address(host)) {
                return true;
            }
            if (forceServer) {
                throw new TURISyntaxException(host, TString.wrap(""), 0);
            }
            return false;
        }

        private boolean isValidDomainName(TString host) {
            char ch;
            int next;
            try {
                TURIEncoderDecoder.validateSimple(host, TString.wrap("-."));
            }
            catch (TURISyntaxException e) {
                return false;
            }
            int index = 0;
            while ((next = host.indexOf(46, index)) != -1) {
                if (host.charAt(index) == '-' || host.charAt(next - 1) == '-') {
                    return false;
                }
                index = next + 1;
            }
            if (host.charAt(index) == '-' || host.charAt(host.length() - 1) == '-') {
                return false;
            }
            TString label = host.substring(index);
            return label.equals(host) || (ch = label.charAt(0)) < '0' || ch > '9';
        }

        private boolean isValidIPv4Address(TString host) {
            try {
                int index = host.indexOf(46);
                int num = TInteger.parseInt(host.substring(0, index));
                if (num < 0 || num > 255) {
                    return false;
                }
                int index2 = host.indexOf(46, index + 1);
                num = TInteger.parseInt(host.substring(index + 1, index2));
                if (num < 0 || num > 255) {
                    return false;
                }
                index = host.indexOf(46, index2 + 1);
                num = TInteger.parseInt(host.substring(index2 + 1, index));
                if (num < 0 || num > 255) {
                    return false;
                }
                num = TInteger.parseInt(host.substring(index + 1));
                if (num < 0 || num > 255) {
                    return false;
                }
            }
            catch (TException e) {
                return false;
            }
            return true;
        }

        private boolean isValidIP6Address(TString ipAddress) {
            int length = ipAddress.length();
            boolean doubleColon = false;
            int numberOfColons = 0;
            int numberOfPeriods = 0;
            TString word = TString.wrap("");
            char c = '\u0000';
            char prevChar = '\u0000';
            int offset = 0;
            if (length < 2) {
                return false;
            }
            block6: for (int i = 0; i < length; ++i) {
                prevChar = c;
                c = ipAddress.charAt(i);
                switch (c) {
                    case '[': {
                        if (i != 0) {
                            return false;
                        }
                        if (ipAddress.charAt(length - 1) != ']') {
                            return false;
                        }
                        if (ipAddress.charAt(1) == ':' && ipAddress.charAt(2) != ':') {
                            return false;
                        }
                        offset = 1;
                        if (length >= 4) continue block6;
                        return false;
                    }
                    case ']': {
                        if (i != length - 1) {
                            return false;
                        }
                        if (ipAddress.charAt(0) == '[') continue block6;
                        return false;
                    }
                    case '.': {
                        if (++numberOfPeriods > 3) {
                            return false;
                        }
                        if (!this.isValidIP4Word(word)) {
                            return false;
                        }
                        if (numberOfColons != 6 && !doubleColon) {
                            return false;
                        }
                        if (numberOfColons == 7 && ipAddress.charAt(0 + offset) != ':' && ipAddress.charAt(1 + offset) != ':') {
                            return false;
                        }
                        word = TString.wrap("");
                        continue block6;
                    }
                    case ':': {
                        if (++numberOfColons > 7) {
                            return false;
                        }
                        if (numberOfPeriods > 0) {
                            return false;
                        }
                        if (prevChar == ':') {
                            if (doubleColon) {
                                return false;
                            }
                            doubleColon = true;
                        }
                        word = TString.wrap("");
                        continue block6;
                    }
                    default: {
                        if (word.length() > 3) {
                            return false;
                        }
                        if (!this.isValidHexChar(c)) {
                            return false;
                        }
                        word = word.concat(TString.valueOf(c));
                    }
                }
            }
            if (numberOfPeriods > 0) {
                if (numberOfPeriods != 3 || !this.isValidIP4Word(word)) {
                    return false;
                }
            } else {
                if (numberOfColons != 7 && !doubleColon) {
                    return false;
                }
                if (word.isEmpty() && ipAddress.charAt(length - 1 - offset) != ':' && ipAddress.charAt(length - 2 - offset) != ':') {
                    return false;
                }
            }
            return true;
        }

        private boolean isValidIP4Word(TString word) {
            if (word.length() < 1 || word.length() > 3) {
                return false;
            }
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return TInteger.parseInt(word) <= 255;
        }

        private boolean isValidHexChar(char c) {
            return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
        }
    }
}

