/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TJointSet;
import org.teavm.classlib.java.util.regex.TLexer;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;

class TDecomposedCharSet
extends TJointSet {
    private int readCharsForCodePoint = 1;
    private String decomposedCharUTF16 = null;
    private int[] decomposedChar;
    private int decomposedCharLength;

    public TDecomposedCharSet(int[] decomposedChar, int decomposedCharLength) {
        this.decomposedChar = decomposedChar;
        this.decomposedCharLength = decomposedCharLength;
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    @Override
    public int matches(int strIndex, CharSequence testString, TMatchResultImpl matchResult) {
        int[] decCodePoint = new int[4];
        int readCodePoints = 0;
        int rightBound = matchResult.getRightBound();
        int i = 0;
        if (strIndex >= rightBound) {
            return -1;
        }
        int curChar = this.codePointAt(strIndex, testString, rightBound);
        strIndex += this.readCharsForCodePoint;
        int[] decCurCodePoint = TLexer.getDecomposition(curChar);
        if (decCurCodePoint == null) {
            decCodePoint[readCodePoints++] = curChar;
        } else {
            i = decCurCodePoint.length;
            System.arraycopy(decCurCodePoint, 0, decCodePoint, 0, i);
            readCodePoints += i;
        }
        if (strIndex < rightBound) {
            curChar = this.codePointAt(strIndex, testString, rightBound);
            while (readCodePoints < 4) {
                if (TLexer.hasDecompositionNonNullCanClass(curChar)) {
                    decCurCodePoint = TLexer.getDecomposition(curChar);
                    if (decCurCodePoint.length == 2) {
                        decCodePoint[readCodePoints++] = decCurCodePoint[0];
                        decCodePoint[readCodePoints++] = decCurCodePoint[1];
                    } else {
                        decCodePoint[readCodePoints++] = decCurCodePoint[0];
                    }
                } else {
                    decCodePoint[readCodePoints++] = curChar;
                }
                if ((strIndex += this.readCharsForCodePoint) >= rightBound) break;
                curChar = this.codePointAt(strIndex, testString, rightBound);
            }
        }
        if (readCodePoints != this.decomposedCharLength) {
            return -1;
        }
        for (i = 0; i < readCodePoints; ++i) {
            if (decCodePoint[i] == this.decomposedChar[i]) continue;
            return -1;
        }
        return this.next.matches(strIndex, testString, matchResult);
    }

    private String getDecomposedChar() {
        if (this.decomposedCharUTF16 == null) {
            StringBuilder strBuff = new StringBuilder();
            for (int i = 0; i < this.decomposedCharLength; ++i) {
                strBuff.append(Character.toChars(this.decomposedChar[i]));
            }
            this.decomposedCharUTF16 = strBuff.toString();
        }
        return this.decomposedCharUTF16;
    }

    @Override
    protected String getName() {
        return "decomposed char:" + this.getDecomposedChar();
    }

    public int codePointAt(int strIndex, CharSequence testString, int rightBound) {
        int curChar;
        this.readCharsForCodePoint = 1;
        if (strIndex < rightBound - 1) {
            char low;
            char high;
            if (Character.isSurrogatePair(high = testString.charAt(strIndex++), low = testString.charAt(strIndex))) {
                char[] curCodePointUTF16 = new char[]{high, low};
                curChar = Character.codePointAt(curCodePointUTF16, 0);
                this.readCharsForCodePoint = 2;
            } else {
                curChar = high;
            }
        } else {
            curChar = testString.charAt(strIndex);
        }
        return curChar;
    }

    @Override
    public boolean first(TAbstractSet set) {
        return set instanceof TDecomposedCharSet ? ((TDecomposedCharSet)set).getDecomposedChar().equals(this.getDecomposedChar()) : true;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        return true;
    }
}

