/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TArrays;
import org.teavm.classlib.java.util.TCheckedCollection;
import org.teavm.classlib.java.util.TCheckedListIterator;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TList;
import org.teavm.classlib.java.util.TListIterator;

class TCheckedList<E>
extends TCheckedCollection<E>
implements TList<E> {
    private TList<E> innerList;

    public TCheckedList(TList<E> innerList, TClass<E> type) {
        super(innerList, type);
        this.innerList = innerList;
    }

    @Override
    public boolean addAll(int index, TCollection<? extends E> c) {
        Object[] items = c.toArray();
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.type.cast(TObject.wrap(items[i]));
        }
        return this.innerList.addAll(index, TArrays.asList(items));
    }

    @Override
    public E get(int index) {
        return this.innerList.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.innerList.set(index, this.type.cast(TObject.wrap(element)));
    }

    @Override
    public void add(int index, E element) {
        this.innerList.add(index, this.type.cast(TObject.wrap(element)));
    }

    @Override
    public E remove(int index) {
        return this.innerList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.innerList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.innerList.lastIndexOf(o);
    }

    @Override
    public TListIterator<E> listIterator() {
        return new TCheckedListIterator<E>(this.innerList.listIterator(), this.type);
    }

    @Override
    public TListIterator<E> listIterator(int index) {
        return new TCheckedListIterator<E>(this.innerList.listIterator(index), this.type);
    }

    @Override
    public TList<E> subList(int fromIndex, int toIndex) {
        return new TCheckedList<E>(this.innerList.subList(fromIndex, toIndex), this.type);
    }
}

