/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.text.TAttributedCharacterIterator;
import org.teavm.classlib.java.text.TAttributedString;
import org.teavm.classlib.java.text.TFieldPosition;
import org.teavm.classlib.java.text.TParseException;
import org.teavm.classlib.java.text.TParsePosition;

public abstract class TFormat
implements TSerializable,
TCloneable {
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    String convertPattern(String template, String fromChars, String toChars, boolean check) {
        if (!check && fromChars.equals(toChars)) {
            return template;
        }
        boolean quote = false;
        StringBuilder output = new StringBuilder();
        int length = template.length();
        for (int i = 0; i < length; ++i) {
            char next = template.charAt(i);
            if (next == '\'') {
                quote = !quote;
            }
            int index = fromChars.indexOf(next);
            if (!quote && index != -1) {
                output.append(toChars.charAt(index));
                continue;
            }
            if (check && !quote && (next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z')) {
                throw new IllegalArgumentException("Invalid pattern char" + next + " in " + template);
            }
            output.append(next);
        }
        if (quote) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        return output.toString();
    }

    public final String format(Object object) {
        return this.format(object, new StringBuffer(), new TFieldPosition(0)).toString();
    }

    public abstract StringBuffer format(Object var1, StringBuffer var2, TFieldPosition var3);

    public TAttributedCharacterIterator formatToCharacterIterator(Object object) {
        return new TAttributedString(this.format(object)).getIterator();
    }

    public Object parseObject(String string) throws TParseException {
        TParsePosition position = new TParsePosition(0);
        Object result = this.parseObject(string, position);
        if (position.getIndex() == 0) {
            throw new TParseException("Format.parseObject(String) parse failure", position.getErrorIndex());
        }
        return result;
    }

    public abstract Object parseObject(String var1, TParsePosition var2);

    static boolean upTo(String string, TParsePosition position, StringBuffer buffer, char stop) {
        int index = position.getIndex();
        int length = string.length();
        boolean lastQuote = false;
        boolean quote = false;
        while (index < length) {
            char ch;
            if ((ch = string.charAt(index++)) == '\'') {
                if (lastQuote) {
                    buffer.append('\'');
                }
                quote = !quote;
                lastQuote = true;
                continue;
            }
            if (ch == stop && !quote) {
                position.setIndex(index);
                return true;
            }
            lastQuote = false;
            buffer.append(ch);
        }
        position.setIndex(index);
        return false;
    }

    static boolean upToWithQuotes(String string, TParsePosition position, StringBuffer buffer, char stop, char start) {
        int index = position.getIndex();
        int length = string.length();
        int count = 1;
        boolean quote = false;
        while (index < length) {
            char ch;
            if ((ch = string.charAt(index++)) == '\'') {
                boolean bl = quote = !quote;
            }
            if (!quote) {
                if (ch == stop) {
                    --count;
                }
                if (count == 0) {
                    position.setIndex(index);
                    return true;
                }
                if (ch == start) {
                    ++count;
                }
            }
            buffer.append(ch);
        }
        throw new IllegalArgumentException("Unmatched braces in the pattern");
    }

    public static class Field
    extends TAttributedCharacterIterator.Attribute {
        protected Field(String fieldName) {
            super(fieldName);
        }
    }
}

