/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TInvalidMarkException;

public abstract class TBuffer {
    int capacity;
    int position;
    int limit;
    int mark = -1;

    TBuffer(int capacity) {
        this.capacity = capacity;
        this.limit = capacity;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final TBuffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException("New position " + newPosition + " is outside of range [0;" + this.limit + "]");
        }
        this.position = newPosition;
        if (newPosition < this.mark) {
            this.mark = 0;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final TBuffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.capacity) {
            throw new IllegalArgumentException("New limit " + newLimit + " is outside of range [0;" + this.capacity + "]");
        }
        if (this.mark > newLimit) {
            this.mark = -1;
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        return this;
    }

    public final TBuffer mark() {
        this.mark = this.position;
        return this;
    }

    public final TBuffer reset() {
        if (this.mark < 0) {
            throw new TInvalidMarkException();
        }
        this.position = this.mark;
        return this;
    }

    public final TBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final TBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final TBuffer rewind() {
        this.mark = -1;
        this.position = 0;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract int arrayOffset();

    public abstract boolean isDirect();
}

