/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.regex;

import org.teavm.classlib.java.util.regex.TAbstractSet;
import org.teavm.classlib.java.util.regex.TJointSet;
import org.teavm.classlib.java.util.regex.TMatchResultImpl;
import org.teavm.classlib.java.util.regex.TPattern;
import org.teavm.classlib.java.util.regex.TPatternSyntaxException;

class TCIBackReferenceSet
extends TJointSet {
    protected int referencedGroup;
    protected int consCounter;

    public TCIBackReferenceSet(int groupIndex, int consCounter) {
        this.referencedGroup = groupIndex;
        this.consCounter = consCounter;
    }

    public int accepts(int strIndex, CharSequence testString) {
        throw new TPatternSyntaxException(strIndex + ", " + testString, "", 0);
    }

    @Override
    public int matches(int stringIndex, CharSequence testString, TMatchResultImpl matchResult) {
        String group = this.getString(matchResult);
        if (group == null || stringIndex + group.length() > matchResult.getRightBound()) {
            return -1;
        }
        for (int i = 0; i < group.length(); ++i) {
            if (group.charAt(i) == testString.charAt(stringIndex + i) || TPattern.getSupplement(group.charAt(i)) == testString.charAt(stringIndex + i)) continue;
            return -1;
        }
        matchResult.setConsumed(this.consCounter, group.length());
        return this.next.matches(stringIndex + group.length(), testString, matchResult);
    }

    @Override
    public TAbstractSet getNext() {
        return this.next;
    }

    @Override
    public void setNext(TAbstractSet next) {
        this.next = next;
    }

    protected String getString(TMatchResultImpl matchResult) {
        String res = matchResult.getGroupNoCheck(this.referencedGroup);
        return res;
    }

    @Override
    public String getName() {
        return "CI back reference: " + this.groupIndex;
    }

    @Override
    public boolean hasConsumed(TMatchResultImpl matchResult) {
        int cons = matchResult.getConsumed(this.consCounter);
        boolean res = cons < 0 || cons > 0;
        matchResult.setConsumed(this.consCounter, -1);
        return res;
    }
}

