/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.unicode;

import java.util.Map;
import org.teavm.classlib.impl.unicode.CLDRLocale;
import org.teavm.classlib.impl.unicode.CLDRReader;
import org.teavm.classlib.impl.unicode.CLDRTimeZone;
import org.teavm.classlib.impl.unicode.TimeZoneLocalization;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public class TimeZoneLocalizationGenerator
implements MetadataGenerator {
    public Resource generateMetadata(MetadataGeneratorContext context, MethodReference method) {
        CLDRReader cldr = (CLDRReader)context.getService(CLDRReader.class);
        ResourceMap localizations = context.createResourceMap();
        for (Map.Entry<String, CLDRLocale> locale : cldr.getKnownLocales().entrySet()) {
            TimeZoneLocalization localization = (TimeZoneLocalization)context.createResource(TimeZoneLocalization.class);
            ResourceMap map = context.createResourceMap();
            localization.setTimeZones((ResourceMap<ResourceMap<StringResource>>)map);
            localizations.put(locale.getKey(), (Resource)localization);
            for (CLDRTimeZone tz : locale.getValue().getTimeZones()) {
                ResourceMap area;
                if (!map.has(tz.getArea())) {
                    area = context.createResourceMap();
                    map.put(tz.getArea(), (Resource)area);
                }
                area = (ResourceMap)map.get(tz.getArea());
                StringResource name = (StringResource)context.createResource(StringResource.class);
                name.setValue(tz.getName());
                area.put(tz.getLocation(), (Resource)name);
            }
        }
        return localizations;
    }
}

