/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.io.TPrintStream;
import org.teavm.classlib.java.lang.SystemNativeGenerator;
import org.teavm.classlib.java.lang.TArrayStoreException;
import org.teavm.classlib.java.lang.TConsoleOutputStream_stderr;
import org.teavm.classlib.java.lang.TConsoleOutputStream_stdout;
import org.teavm.classlib.java.lang.TIndexOutOfBoundsException;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.classlib.java.lang.reflect.TArray;
import org.teavm.dependency.PluggableDependency;
import org.teavm.javascript.spi.GeneratedBy;

public final class TSystem
extends TObject {
    public static final TPrintStream out = new TPrintStream(new TConsoleOutputStream_stdout(), false);
    public static final TPrintStream err = new TPrintStream(new TConsoleOutputStream_stderr(), false);

    private TSystem() {
    }

    public static void arraycopy(TObject src, int srcPos, TObject dest, int destPos, int length) {
        if (src == null || dest == null) {
            throw new TNullPointerException(TString.wrap("Either src or dest is null"));
        }
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > TArray.getLength(src) || destPos + length > TArray.getLength(dest)) {
            throw new TIndexOutOfBoundsException();
        }
        if (src != dest) {
            Class<?> srcType = src.getClass().getComponentType();
            Class<?> targetType = dest.getClass().getComponentType();
            if (srcType == null || targetType == null) {
                throw new TArrayStoreException();
            }
            if (srcType != targetType) {
                if (!srcType.isPrimitive() && !targetType.isPrimitive()) {
                    Object[] srcArray = (Object[])src;
                    int pos = srcPos;
                    for (int i = 0; i < length; ++i) {
                        Object elem;
                        if (targetType.isInstance(elem = srcArray[pos++])) continue;
                        TSystem.doArrayCopy(src, srcPos, dest, destPos, i);
                        throw new TArrayStoreException();
                    }
                    TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
                    return;
                }
                if (!srcType.isPrimitive() || !targetType.isPrimitive()) {
                    throw new TArrayStoreException();
                }
            }
        }
        TSystem.doArrayCopy(src, srcPos, dest, destPos, length);
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    private static native void doArrayCopy(Object var0, int var1, Object var2, int var3, int var4);

    @GeneratedBy(value=SystemNativeGenerator.class)
    public static native long currentTimeMillis();

    public static TString getProperty(TString key) {
        return null;
    }

    public static TString getProperty(TString key, TString def) {
        TString value = TSystem.getProperty(key);
        return value != null ? value : def;
    }

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native void setErr(TPrintStream var0);

    @GeneratedBy(value=SystemNativeGenerator.class)
    @PluggableDependency(value=SystemNativeGenerator.class)
    public static native void setOut(TPrintStream var0);

    public static void gc() {
    }

    public static void runFinalization() {
    }

    public static long nanoTime() {
        return TSystem.currentTimeMillis() * 10000000L;
    }

    public static int identityHashCode(Object x) {
        return ((TObject)x).identity();
    }

    public static TString lineSeparator() {
        return TString.wrap("\n");
    }
}

