/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import org.teavm.classlib.java.io.TInputStream;
import org.teavm.classlib.java.lang.TMath;

public class TByteArrayInputStream
extends TInputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public TByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.mark = offset;
        this.count = offset + length;
    }

    public TByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int bytesToRead = TMath.min(len, this.count - this.pos);
        for (int i = 0; i < bytesToRead; ++i) {
            b[off++] = this.buf[this.pos++];
        }
        return bytesToRead > 0 ? bytesToRead : -1;
    }

    @Override
    public long skip(long n) {
        int bytesSkipped = (int)TMath.min(n, (long)(this.count - this.pos));
        this.pos += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }
}

