/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import java.io.IOException;
import org.teavm.classlib.impl.unicode.UnicodeHelper;
import org.teavm.classlib.impl.unicode.UnicodeSupport;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.model.MethodReference;

public class CharacterNativeGenerator
implements Generator,
DependencyPlugin {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "toLowerCase": {
                writer.append("return String.fromCharCode(").append(context.getParameterName(1)).append(").toLowerCase().charCodeAt(0)|0;").softNewLine();
                break;
            }
            case "toUpperCase": {
                writer.append("return String.fromCharCode(").append(context.getParameterName(1)).append(").toUpperCase().charCodeAt(0)|0;").softNewLine();
                break;
            }
            case "obtainDigitMapping": {
                this.generateObtainDigitMapping(writer);
                break;
            }
            case "obtainClasses": {
                this.generateObtainClasses(writer);
            }
        }
    }

    public void methodAchieved(DependencyAgent agent, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "obtainDigitMapping": 
            case "obtainClasses": {
                method.getResult().propagate(agent.getType("java.lang.String"));
            }
        }
    }

    private void generateObtainDigitMapping(SourceWriter writer) throws IOException {
        String str = UnicodeHelper.encodeIntByte(UnicodeSupport.getDigitValues());
        writer.append("return $rt_str(");
        this.splitString(writer, str);
        writer.append(");").softNewLine();
    }

    private void generateObtainClasses(SourceWriter writer) throws IOException {
        String str = UnicodeHelper.compressRle(UnicodeSupport.getClasses());
        writer.append("return $rt_str(");
        this.splitString(writer, str);
        writer.append(");").softNewLine();
    }

    private void splitString(SourceWriter writer, String str) throws IOException {
        for (int i = 0; i < str.length(); i += 512) {
            if (i > 0) {
                writer.ws().append("+").newLine();
            }
            int j = Math.min(i + 512, str.length());
            writer.append("\"").append(str.substring(i, j)).append("\"");
        }
    }
}

