/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import org.teavm.classlib.java.io.TIOException;
import org.teavm.classlib.java.io.TReader;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TMath;
import org.teavm.classlib.java.lang.TNullPointerException;
import org.teavm.classlib.java.lang.TString;

public class TStringReader
extends TReader {
    private TString string;
    private int index;
    private int mark = 0;

    public TStringReader(TString string) {
        if (string == null) {
            throw new TNullPointerException();
        }
        this.string = string;
    }

    @Override
    public int read() throws TIOException {
        this.checkOpened();
        if (this.index >= this.string.length()) {
            return -1;
        }
        return this.string.charAt(this.index++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws TIOException {
        this.checkOpened();
        if (this.index >= this.string.length()) {
            return -1;
        }
        int n = TMath.min(this.string.length() - this.index, len);
        for (int i = 0; i < n; ++i) {
            cbuf[off++] = this.string.charAt(this.index++);
        }
        return n;
    }

    @Override
    public long skip(long n) throws TIOException {
        this.checkOpened();
        n = n < 0L ? TMath.max(n, (long)(-this.index)) : TMath.min((long)(this.string.length() - this.index), n);
        this.index = (int)((long)this.index + n);
        return n;
    }

    @Override
    public boolean ready() throws TIOException {
        this.checkOpened();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws TIOException {
        this.checkOpened();
        if (readAheadLimit < 0) {
            throw new TIllegalArgumentException();
        }
        this.mark = this.index;
    }

    @Override
    public void reset() throws TIOException {
        this.checkOpened();
        this.index = this.mark;
    }

    @Override
    public void close() {
        this.string = null;
    }

    private void checkOpened() throws TIOException {
        if (this.string == null) {
            throw new TIOException();
        }
    }
}

