/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.charset;

public class ByteBuffer {
    private byte[] data;
    private int end;
    private int pos;

    public ByteBuffer(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteBuffer(byte[] data, int start, int end) {
        this.data = data;
        this.end = end;
        this.pos = start;
    }

    public void put(byte b) {
        this.data[this.pos++] = b;
    }

    public void rewind(int start) {
        this.pos = start;
    }

    public int available() {
        return this.end - this.pos;
    }

    public void back(int count) {
        this.pos -= count;
    }

    public boolean end() {
        return this.pos == this.end;
    }

    public void skip(int count) {
        this.pos += count;
    }

    public byte get() {
        return this.data[this.pos++];
    }

    public int position() {
        return this.pos;
    }

    public void put(ByteBuffer buffer) {
        while (buffer.pos < buffer.end) {
            this.data[this.pos++] = buffer.data[buffer.pos++];
        }
    }
}

