/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.bp.chrono;

import java.util.Locale;
import org.threeten.bp.format.DateTimeFormatterBuilder;
import org.threeten.bp.format.TextStyle;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.Temporal;
import org.threeten.bp.temporal.TemporalAccessor;
import org.threeten.bp.temporal.TemporalAdjuster;
import org.threeten.bp.temporal.TemporalField;
import org.threeten.bp.temporal.TemporalQueries;
import org.threeten.bp.temporal.TemporalQuery;
import org.threeten.bp.temporal.UnsupportedTemporalTypeException;

public interface Era
extends TemporalAccessor,
TemporalAdjuster {
    @Override
    default public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    default public int get(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        return this.range(field).checkValidIntValue(this.getLong(field), field);
    }

    @Override
    default public long getLong(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + String.valueOf(field));
        }
        return field.getFrom(this);
    }

    @Override
    default public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.ERAS;
        }
        if (query == TemporalQueries.chronology() || query == TemporalQueries.zone() || query == TemporalQueries.zoneId() || query == TemporalQueries.offset() || query == TemporalQueries.localDate() || query == TemporalQueries.localTime()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    default public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.ERA, this.getValue());
    }

    public int getValue();

    default public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, style).toFormatter(locale).format(this);
    }
}

