/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import org.teavm.classlib.java.util.zip.TCRC32;
import org.teavm.classlib.java.util.zip.TDataFormatException;
import org.teavm.classlib.java.util.zip.TInflater;
import org.teavm.classlib.java.util.zip.TInflaterInputStream;
import org.teavm.classlib.java.util.zip.TZipConstants;
import org.teavm.classlib.java.util.zip.TZipEntry;
import org.teavm.classlib.java.util.zip.TZipException;

public class TZipInputStream
extends TInflaterInputStream
implements TZipConstants {
    static final int DEFLATED = 8;
    static final int STORED = 0;
    static final int ZIPDataDescriptorFlag = 8;
    static final int ZIPLocalHeaderVersionNeeded = 20;
    private boolean entriesEnd;
    private boolean hasDD;
    private int entryIn;
    private int inRead;
    private int lastRead;
    TZipEntry currentEntry;
    private final byte[] hdrBuf = new byte[26];
    private final TCRC32 crc = new TCRC32();
    private byte[] nameBuf = new byte[256];
    private char[] charBuf = new char[256];

    public TZipInputStream(InputStream stream) {
        super(new PushbackInputStream(stream, 512), new TInflater(true));
        if (stream == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeEntry();
            super.close();
        }
    }

    public void closeEntry() throws IOException {
        Exception failure;
        block12: {
            int out;
            int inB;
            if (this.closed) {
                throw new IOException();
            }
            if (this.currentEntry == null) {
                return;
            }
            failure = null;
            try {
                this.skip(Long.MAX_VALUE);
            }
            catch (Exception e) {
                failure = e;
            }
            if (this.currentEntry.compressionMethod == 8) {
                inB = this.inf.getTotalIn();
                out = this.inf.getTotalOut();
            } else {
                inB = this.inRead;
                out = this.inRead;
            }
            int diff = this.entryIn - inB;
            if (diff != 0) {
                ((PushbackInputStream)this.in).unread(this.buf, this.len - diff, diff);
            }
            try {
                this.readAndVerifyDataDescriptor(inB, out);
            }
            catch (Exception e) {
                if (failure != null) break block12;
                failure = e;
            }
        }
        this.inf.reset();
        this.lastRead = 0;
        this.inRead = 0;
        this.entryIn = 0;
        this.len = 0;
        this.crc.reset();
        this.currentEntry = null;
        if (failure != null) {
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            throw new AssertionError((Object)failure);
        }
    }

    private void readAndVerifyDataDescriptor(int inB, int out) throws IOException {
        if (this.hasDD) {
            this.in.read(this.hdrBuf, 0, 16);
            if (this.getLong(this.hdrBuf, 0) != 134695760L) {
                throw new TZipException();
            }
            this.currentEntry.crc = this.getLong(this.hdrBuf, 4);
            this.currentEntry.compressedSize = this.getLong(this.hdrBuf, 8);
            this.currentEntry.size = this.getLong(this.hdrBuf, 12);
        }
        if (this.currentEntry.crc != this.crc.getValue()) {
            throw new TZipException();
        }
        if (this.currentEntry.compressedSize != (long)inB || this.currentEntry.size != (long)out) {
            throw new TZipException();
        }
    }

    public TZipEntry getNextEntry() throws IOException {
        int flen;
        int count;
        this.closeEntry();
        if (this.entriesEnd) {
            return null;
        }
        int x = 0;
        for (count = 0; count != 4; count += x) {
            x = this.in.read(this.hdrBuf, count, 4 - count);
            if (x != -1) continue;
            return null;
        }
        long hdr = this.getLong(this.hdrBuf, 0);
        if (hdr == 33639248L) {
            this.entriesEnd = true;
            return null;
        }
        if (hdr != 67324752L) {
            return null;
        }
        for (count = 0; count != 26; count += x) {
            x = this.in.read(this.hdrBuf, count, 26 - count);
            if (x != -1) continue;
            throw new EOFException();
        }
        int version = this.getShort(this.hdrBuf, 0) & 0xFF;
        if (version > 20) {
            throw new TZipException();
        }
        int flags = this.getShort(this.hdrBuf, 2);
        this.hasDD = (flags & 8) == 8;
        int cetime = this.getShort(this.hdrBuf, 6);
        int cemodDate = this.getShort(this.hdrBuf, 8);
        int cecompressionMethod = this.getShort(this.hdrBuf, 4);
        long cecrc = 0L;
        long cecompressedSize = 0L;
        long cesize = -1L;
        if (!this.hasDD) {
            cecrc = this.getLong(this.hdrBuf, 10);
            cecompressedSize = this.getLong(this.hdrBuf, 14);
            cesize = this.getLong(this.hdrBuf, 18);
        }
        if ((flen = this.getShort(this.hdrBuf, 22)) == 0) {
            throw new TZipException();
        }
        int elen = this.getShort(this.hdrBuf, 24);
        count = 0;
        if (flen > this.nameBuf.length) {
            this.nameBuf = new byte[flen];
            this.charBuf = new char[flen];
        }
        while (count != flen) {
            x = this.in.read(this.nameBuf, count, flen - count);
            count += x;
            if (x != -1) continue;
            throw new EOFException();
        }
        this.currentEntry = this.createZipEntry(new String(this.nameBuf, 0, flen, StandardCharsets.UTF_8));
        this.currentEntry.time = cetime;
        this.currentEntry.modDate = cemodDate;
        this.currentEntry.setMethod(cecompressionMethod);
        if (cesize != -1L) {
            this.currentEntry.setCrc(cecrc);
            this.currentEntry.setSize(cesize);
            this.currentEntry.setCompressedSize(cecompressedSize);
        }
        if (elen > 0) {
            byte[] e = new byte[elen];
            for (count = 0; count != elen; count += x) {
                x = this.in.read(e, count, elen - count);
                if (x != -1) continue;
                throw new EOFException();
            }
            this.currentEntry.setExtra(e);
        }
        return this.currentEntry;
    }

    @Override
    public int read(byte[] buffer, int start, int length) throws IOException {
        int read;
        if (this.closed) {
            throw new IOException();
        }
        if (this.inf.finished() || this.currentEntry == null) {
            return -1;
        }
        if (start > buffer.length || length < 0 || start < 0 || buffer.length - start < length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.currentEntry.compressionMethod == 0) {
            int toRead;
            int csize = (int)this.currentEntry.size;
            if (this.inRead >= csize) {
                return -1;
            }
            if (this.lastRead >= this.len) {
                this.lastRead = 0;
                this.len = this.in.read(this.buf);
                if (this.len == -1) {
                    this.eof = true;
                    return -1;
                }
                this.entryIn += this.len;
            }
            if (csize - this.inRead < (toRead = Math.min(length, this.len - this.lastRead))) {
                toRead = csize - this.inRead;
            }
            System.arraycopy(this.buf, this.lastRead, buffer, start, toRead);
            this.lastRead += toRead;
            this.inRead += toRead;
            this.crc.update(buffer, start, toRead);
            return toRead;
        }
        if (this.inf.needsInput()) {
            this.fill();
            if (this.len > 0) {
                this.entryIn += this.len;
            }
        }
        try {
            read = this.inf.inflate(buffer, start, length);
        }
        catch (TDataFormatException e) {
            throw new TZipException(e.getMessage());
        }
        if (read == 0 && this.inf.finished()) {
            return -1;
        }
        this.crc.update(buffer, start, read);
        return read;
    }

    @Override
    public long skip(long value) throws IOException {
        long skipped;
        int x;
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        byte[] b = new byte[(int)Math.min(value, 2048L)];
        for (skipped = 0L; skipped != value; skipped += (long)x) {
            long rem = value - skipped;
            x = this.read(b, 0, (int)((long)b.length > rem ? rem : (long)b.length));
            if (x != -1) continue;
            return skipped;
        }
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        return this.currentEntry == null || (long)this.inRead < this.currentEntry.size ? 1 : 0;
    }

    protected TZipEntry createZipEntry(String name) {
        return new TZipEntry(name);
    }

    private int getShort(byte[] buffer, int off) {
        return buffer[off] & 0xFF | (buffer[off + 1] & 0xFF) << 8;
    }

    private long getLong(byte[] buffer, int off) {
        long l = 0L;
        l |= (long)(buffer[off] & 0xFF);
        l |= (long)((buffer[off + 1] & 0xFF) << 8);
        l |= (long)((buffer[off + 2] & 0xFF) << 16);
        return l |= (long)(buffer[off + 3] & 0xFF) << 24;
    }
}

