/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.longimpl;

import java.util.function.LongPredicate;
import org.teavm.classlib.java.util.stream.longimpl.TSimpleLongStreamImpl;

public class TDropWhileLongStream
extends TSimpleLongStreamImpl {
    private TSimpleLongStreamImpl sourceStream;
    private LongPredicate predicate;
    private boolean isStarted;

    TDropWhileLongStream(TSimpleLongStreamImpl sourceStream, LongPredicate predicate) {
        this.sourceStream = sourceStream;
        this.predicate = predicate;
    }

    @Override
    public boolean next(final LongPredicate consumer) {
        if (!this.isStarted) {
            var skippingPredicate = new LongPredicate(){
                boolean consumerCanTakeMore;

                @Override
                public boolean test(long t) {
                    if (TDropWhileLongStream.this.predicate.test(t)) {
                        return true;
                    }
                    TDropWhileLongStream.this.isStarted = true;
                    this.consumerCanTakeMore = consumer.test(t);
                    return false;
                }
            };
            boolean result = this.sourceStream.next(skippingPredicate);
            if (!result) {
                return false;
            }
            if (!skippingPredicate.consumerCanTakeMore) {
                return true;
            }
        }
        return this.sourceStream.next(consumer);
    }
}

